/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.server.tomcat;

import com.linecorp.armeria.server.tomcat.ManagedConnectorFactory;
import com.linecorp.armeria.server.tomcat.ManagedTomcatService;
import com.linecorp.armeria.server.tomcat.TomcatService;
import com.linecorp.armeria.server.tomcat.TomcatServiceConfig;
import com.linecorp.armeria.server.tomcat.TomcatServiceException;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.PosixFilePermission;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import org.apache.catalina.LifecycleState;
import org.apache.catalina.Realm;
import org.apache.catalina.Server;
import org.apache.catalina.connector.Connector;
import org.apache.catalina.core.StandardServer;
import org.apache.catalina.realm.NullRealm;

public final class TomcatServiceBuilder {
    private static final String DEFAULT_SERVICE_NAME = "Catalina";
    private final Path docBase;
    @Nullable
    private final String jarRoot;
    private final List<Consumer<? super StandardServer>> configurators = new ArrayList<Consumer<? super StandardServer>>();
    private String serviceName = "Catalina";
    @Nullable
    private String engineName;
    @Nullable
    private Path baseDir;
    @Nullable
    private Realm realm;
    @Nullable
    private String hostname;

    TomcatServiceBuilder(Path docBase, @Nullable String jarRoot) {
        this.docBase = docBase;
        this.jarRoot = jarRoot;
    }

    public TomcatServiceBuilder serviceName(String serviceName) {
        this.serviceName = Objects.requireNonNull(serviceName, "serviceName");
        return this;
    }

    public TomcatServiceBuilder engineName(String engineName) {
        this.engineName = Objects.requireNonNull(engineName, "engineName");
        return this;
    }

    public TomcatServiceBuilder baseDir(String baseDir) {
        return this.baseDir(Paths.get(Objects.requireNonNull(baseDir, "baseDir"), new String[0]));
    }

    public TomcatServiceBuilder baseDir(Path baseDir) {
        if (!Files.isDirectory(baseDir = Objects.requireNonNull(baseDir, "baseDir").toAbsolutePath(), new LinkOption[0])) {
            throw new IllegalArgumentException("baseDir: " + baseDir + " (expected: a directory)");
        }
        this.baseDir = baseDir;
        return this;
    }

    public TomcatServiceBuilder realm(Realm realm) {
        Objects.requireNonNull(realm, "realm");
        this.realm = realm;
        return this;
    }

    public TomcatServiceBuilder hostname(String hostname) {
        this.hostname = TomcatServiceBuilder.validateHostname(hostname);
        return this;
    }

    private static String validateHostname(String hostname) {
        Objects.requireNonNull(hostname, "hostname");
        if (hostname.isEmpty()) {
            throw new IllegalArgumentException("hostname is empty.");
        }
        return hostname;
    }

    public TomcatServiceBuilder configurator(Consumer<? super StandardServer> configurator) {
        this.configurators.add(Objects.requireNonNull(configurator, "configurator"));
        return this;
    }

    public TomcatService build() {
        Realm realm;
        Path baseDir = this.baseDir;
        if (baseDir == null) {
            try {
                baseDir = Files.createTempDirectory("tomcat-armeria.", new FileAttribute[0]);
            }
            catch (IOException e) {
                throw new TomcatServiceException("failed to create a temporary directory", e);
            }
            try {
                Files.setPosixFilePermissions(baseDir, EnumSet.of(PosixFilePermission.OWNER_READ, PosixFilePermission.OWNER_WRITE, PosixFilePermission.OWNER_EXECUTE));
            }
            catch (UnsupportedOperationException e) {
            }
            catch (IOException e) {
                throw new TomcatServiceException("failed to secure a temporary directory", e);
            }
        }
        if ((realm = this.realm) == null) {
            realm = new NullRealm();
        }
        Consumer<Connector> postStopTask = connector -> {
            Server server = connector.getService().getServer();
            if (server.getState() == LifecycleState.STOPPED) {
                try {
                    TomcatService.logger.info("Destroying an embedded Tomcat: {}", (Object)TomcatService.toString(server));
                    server.destroy();
                }
                catch (Exception e) {
                    TomcatService.logger.warn("Failed to destroy an embedded Tomcat: {}", (Object)TomcatService.toString(server), (Object)e);
                }
            }
        };
        return new ManagedTomcatService(null, new ManagedConnectorFactory(new TomcatServiceConfig(this.serviceName, this.engineName, baseDir, realm, this.hostname, this.docBase, this.jarRoot, Collections.unmodifiableList(this.configurators))), postStopTask);
    }

    public String toString() {
        return TomcatServiceConfig.toString(this, this.serviceName, this.engineName, this.baseDir, this.realm, this.hostname, this.docBase, this.jarRoot);
    }
}

