/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.server.tomcat;

import com.linecorp.armeria.server.tomcat.TomcatService;
import java.util.Objects;
import javax.annotation.Nullable;
import org.apache.catalina.connector.Connector;
import org.apache.catalina.startup.Tomcat;

final class UnmanagedTomcatService
extends TomcatService {
    @Nullable
    private final String hostName;
    @Nullable
    private final Tomcat tomcat;
    @Nullable
    private final Connector connector;

    UnmanagedTomcatService(Tomcat tomcat) {
        this.hostName = null;
        this.tomcat = Objects.requireNonNull(tomcat, "tomcat");
        this.connector = null;
    }

    UnmanagedTomcatService(Connector connector, @Nullable String hostName) {
        this.hostName = hostName;
        this.tomcat = null;
        this.connector = Objects.requireNonNull(connector, "connector");
    }

    @Override
    public Connector connector() {
        if (this.connector != null) {
            return this.connector;
        }
        assert (this.tomcat != null);
        return this.tomcat.getConnector();
    }

    @Override
    public String hostName() {
        if (this.hostName != null) {
            return this.hostName;
        }
        if (this.tomcat != null) {
            return this.tomcat.getEngine().getDefaultHost();
        }
        return null;
    }
}

