/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.internal.tracing;

import brave.Span;
import com.linecorp.armeria.common.RpcRequest;
import com.linecorp.armeria.common.logging.RequestLog;
import com.linecorp.armeria.internal.tracing.SpanContextUtil;
import java.net.SocketAddress;

public final class SpanTags {
    private static final String WIRE_SEND_ANNOTATION = "ws";
    private static final String WIRE_RECEIVE_ANNOTATION = "wr";

    public static void addTags(Span span, RequestLog log) {
        Object requestContent;
        SocketAddress laddr;
        SocketAddress raddr;
        String host = log.requestHeaders().authority();
        assert (host != null);
        span.tag("http.host", host);
        StringBuilder uriBuilder = new StringBuilder().append(log.scheme().uriText()).append("://").append(host).append(log.path());
        if (log.query() != null) {
            uriBuilder.append('?').append(log.query());
        }
        span.tag("http.method", log.method().name()).tag("http.path", log.path()).tag("http.url", uriBuilder.toString()).tag("http.status_code", log.status().codeAsText());
        Throwable responseCause = log.responseCause();
        if (responseCause != null) {
            span.tag("error", responseCause.toString());
        }
        if ((raddr = log.context().remoteAddress()) != null) {
            span.tag("address.remote", raddr.toString());
        }
        if ((laddr = log.context().localAddress()) != null) {
            span.tag("address.local", laddr.toString());
        }
        if ((requestContent = log.requestContent()) instanceof RpcRequest) {
            span.name(((RpcRequest)requestContent).method());
        }
    }

    public static void logWireSend(Span span, long wireSendTimeNanos, RequestLog requestLog) {
        span.annotate(SpanContextUtil.wallTimeMicros(requestLog, wireSendTimeNanos), WIRE_SEND_ANNOTATION);
    }

    public static void logWireReceive(Span span, long wireSendTimeNanos, RequestLog requestLog) {
        span.annotate(SpanContextUtil.wallTimeMicros(requestLog, wireSendTimeNanos), WIRE_RECEIVE_ANNOTATION);
    }

    private SpanTags() {
    }
}

