/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.client.tracing;

import brave.Span;
import brave.Tracer;
import brave.Tracing;
import brave.propagation.Propagation;
import brave.propagation.TraceContext;
import com.linecorp.armeria.client.Client;
import com.linecorp.armeria.client.ClientRequestContext;
import com.linecorp.armeria.client.SimpleDecoratingClient;
import com.linecorp.armeria.common.HttpHeaders;
import com.linecorp.armeria.common.HttpRequest;
import com.linecorp.armeria.common.HttpResponse;
import com.linecorp.armeria.common.Request;
import com.linecorp.armeria.common.logging.RequestLog;
import com.linecorp.armeria.common.logging.RequestLogAvailability;
import com.linecorp.armeria.common.tracing.RequestContextCurrentTraceContext;
import com.linecorp.armeria.internal.shaded.guava.base.Strings;
import com.linecorp.armeria.internal.tracing.AsciiStringKeyFactory;
import com.linecorp.armeria.internal.tracing.SpanContextUtil;
import com.linecorp.armeria.internal.tracing.SpanTags;
import io.netty.handler.codec.Headers;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.function.Function;
import javax.annotation.Nullable;

public class HttpTracingClient
extends SimpleDecoratingClient<HttpRequest, HttpResponse> {
    private final Tracer tracer;
    private final TraceContext.Injector<HttpHeaders> injector;
    @Nullable
    private final String remoteServiceName;

    public static Function<Client<HttpRequest, HttpResponse>, HttpTracingClient> newDecorator(Tracing tracing) {
        return HttpTracingClient.newDecorator(tracing, null);
    }

    public static Function<Client<HttpRequest, HttpResponse>, HttpTracingClient> newDecorator(Tracing tracing, @Nullable String remoteServiceName) {
        RequestContextCurrentTraceContext.ensureScopeUsesRequestContext(tracing);
        return delegate -> new HttpTracingClient((Client<HttpRequest, HttpResponse>)delegate, tracing, remoteServiceName);
    }

    protected HttpTracingClient(Client<HttpRequest, HttpResponse> delegate, Tracing tracing, @Nullable String remoteServiceName) {
        super(delegate);
        this.tracer = tracing.tracer();
        this.injector = tracing.propagationFactory().create((Propagation.KeyFactory)AsciiStringKeyFactory.INSTANCE).injector(Headers::set);
        this.remoteServiceName = remoteServiceName;
    }

    public HttpResponse execute(ClientRequestContext ctx, HttpRequest req) throws Exception {
        Span span = this.tracer.nextSpan();
        this.injector.inject(span.context(), (Object)req.headers());
        if (span.isNoop()) {
            return (HttpResponse)this.delegate().execute(ctx, (Request)req);
        }
        String method = ctx.method().name();
        span.kind(Span.Kind.CLIENT).name(method);
        ctx.log().addListener(log -> SpanContextUtil.startSpan(span, log), RequestLogAvailability.REQUEST_START);
        ctx.onChild(RequestContextCurrentTraceContext::copy);
        ctx.log().addListener(log -> {
            SpanTags.logWireSend(span, log.requestFirstBytesTransferredTimeNanos(), log);
            SpanTags.logWireReceive(span, log.responseFirstBytesTransferredTimeNanos(), log);
            this.finishSpan(span, log);
        }, RequestLogAvailability.COMPLETE);
        try (Tracer.SpanInScope ignored = this.tracer.withSpanInScope(span);){
            HttpResponse httpResponse = (HttpResponse)this.delegate().execute(ctx, (Request)req);
            return httpResponse;
        }
    }

    private void finishSpan(Span span, RequestLog log) {
        this.setRemoteEndpoint(span, log);
        SpanContextUtil.closeSpan(span, log);
    }

    private void setRemoteEndpoint(Span span, RequestLog log) {
        String authority;
        int port;
        InetAddress address;
        SocketAddress remoteAddress = log.context().remoteAddress();
        if (remoteAddress instanceof InetSocketAddress) {
            InetSocketAddress socketAddress = (InetSocketAddress)remoteAddress;
            address = socketAddress.getAddress();
            port = socketAddress.getPort();
        } else {
            address = null;
            port = 0;
        }
        String remoteServiceName = this.remoteServiceName != null ? this.remoteServiceName : (!"?".equals(authority = log.requestHeaders().authority()) ? authority : (address != null ? String.valueOf(remoteAddress) : null));
        if (!Strings.isNullOrEmpty((String)remoteServiceName)) {
            span.remoteServiceName(remoteServiceName);
        }
        if (address != null) {
            span.remoteIpAndPort(address.getHostAddress(), port);
        }
    }
}

