/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.client.zookeeper;

import com.linecorp.armeria.client.Endpoint;
import com.linecorp.armeria.client.endpoint.DynamicEndpointGroup;
import com.linecorp.armeria.client.endpoint.EndpointSelectionStrategy;
import com.linecorp.armeria.client.zookeeper.ZooKeeperDiscoverySpec;
import com.linecorp.armeria.client.zookeeper.ZooKeeperEndpointGroupBuilder;
import com.linecorp.armeria.common.annotation.Nullable;
import com.linecorp.armeria.internal.shaded.guava.base.Strings;
import io.netty.util.concurrent.DefaultThreadFactory;
import java.io.IOException;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ThreadFactory;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.imps.CuratorFrameworkState;
import org.apache.curator.framework.recipes.cache.PathChildrenCache;
import org.apache.curator.framework.recipes.cache.PathChildrenCacheEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ZooKeeperEndpointGroup
extends DynamicEndpointGroup {
    private static final Logger logger = LoggerFactory.getLogger(ZooKeeperEndpointGroup.class);
    private static final ThreadFactory closeCuratorFrameworkThreadFactory = new DefaultThreadFactory("armeria-close-CuratorFramework");
    private final boolean internalClient;
    private final CuratorFramework client;
    private final PathChildrenCache pathChildrenCache;

    public static ZooKeeperEndpointGroup of(String zkConnectionStr, String znodePath, ZooKeeperDiscoverySpec spec) {
        return ZooKeeperEndpointGroup.builder(zkConnectionStr, znodePath, spec).build();
    }

    public static ZooKeeperEndpointGroup of(CuratorFramework client, String znodePath, ZooKeeperDiscoverySpec spec) {
        return ZooKeeperEndpointGroup.builder(client, znodePath, spec).build();
    }

    public static ZooKeeperEndpointGroupBuilder builder(String zkConnectionStr, String znodePath, ZooKeeperDiscoverySpec spec) {
        return new ZooKeeperEndpointGroupBuilder(zkConnectionStr, znodePath, spec);
    }

    public static ZooKeeperEndpointGroupBuilder builder(CuratorFramework client, String znodePath, ZooKeeperDiscoverySpec spec) {
        return new ZooKeeperEndpointGroupBuilder(client, znodePath, spec);
    }

    ZooKeeperEndpointGroup(EndpointSelectionStrategy selectionStrategy, CuratorFramework client, String znodePath, ZooKeeperDiscoverySpec discoverySpec, boolean internalClient) {
        super(selectionStrategy);
        String pathForDiscovery;
        this.internalClient = internalClient;
        this.client = Objects.requireNonNull(client, "client");
        if (client.getState() != CuratorFrameworkState.STARTED) {
            client.start();
        }
        String path = Strings.isNullOrEmpty((String)(pathForDiscovery = discoverySpec.path())) ? znodePath : znodePath + pathForDiscovery;
        try {
            this.pathChildrenCache = this.pathChildrenCache(path, discoverySpec);
            this.pathChildrenCache.start();
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    private PathChildrenCache pathChildrenCache(String path, ZooKeeperDiscoverySpec spec) {
        PathChildrenCache pathChildrenCache = new PathChildrenCache(this.client, path, true);
        pathChildrenCache.getListenable().addListener((c, event) -> {
            switch (event.getType()) {
                case CHILD_ADDED: {
                    Endpoint addedEndpoint = ZooKeeperEndpointGroup.endpoint(spec, event);
                    if (addedEndpoint == null) break;
                    this.addEndpoint(addedEndpoint);
                    break;
                }
                case CHILD_REMOVED: {
                    Endpoint removedEndpoint = ZooKeeperEndpointGroup.endpoint(spec, event);
                    if (removedEndpoint == null) break;
                    this.removeEndpoint(removedEndpoint);
                    break;
                }
            }
        });
        return pathChildrenCache;
    }

    @Nullable
    private static Endpoint endpoint(ZooKeeperDiscoverySpec spec, PathChildrenCacheEvent event) {
        return spec.decode(event.getData().getData());
    }

    protected void doCloseAsync(CompletableFuture<?> future) {
        try {
            this.pathChildrenCache.close();
        }
        catch (IOException e) {
            logger.warn("Failed to close PathChildrenCache:", (Throwable)e);
        }
        finally {
            if (this.internalClient) {
                closeCuratorFrameworkThreadFactory.newThread(() -> {
                    try {
                        this.client.close();
                    }
                    catch (Throwable cause) {
                        logger.warn("Failed to close CuratorFramework:", cause);
                    }
                    finally {
                        future.complete(null);
                    }
                }).start();
            } else {
                future.complete(null);
            }
        }
    }
}

