/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.client.zookeeper;

import com.linecorp.armeria.client.endpoint.EndpointSelectionStrategy;
import com.linecorp.armeria.client.zookeeper.ZooKeeperDiscoverySpec;
import com.linecorp.armeria.client.zookeeper.ZooKeeperEndpointGroup;
import com.linecorp.armeria.common.zookeeper.AbstractCuratorFrameworkBuilder;
import java.time.Duration;
import java.util.Objects;
import java.util.function.Consumer;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.CuratorFrameworkFactory;

public final class ZooKeeperEndpointGroupBuilder
extends AbstractCuratorFrameworkBuilder {
    private final ZooKeeperDiscoverySpec spec;
    private EndpointSelectionStrategy selectionStrategy = EndpointSelectionStrategy.weightedRoundRobin();

    ZooKeeperEndpointGroupBuilder(String zkConnectionStr, String znodePath, ZooKeeperDiscoverySpec spec) {
        super(zkConnectionStr, znodePath);
        this.spec = Objects.requireNonNull(spec, "spec");
    }

    ZooKeeperEndpointGroupBuilder(CuratorFramework client, String znodePath, ZooKeeperDiscoverySpec spec) {
        super(client, znodePath);
        this.spec = Objects.requireNonNull(spec, "spec");
    }

    public ZooKeeperEndpointGroupBuilder selectionStrategy(EndpointSelectionStrategy selectionStrategy) {
        this.selectionStrategy = Objects.requireNonNull(selectionStrategy, "selectionStrategy");
        return this;
    }

    public ZooKeeperEndpointGroup build() {
        CuratorFramework client = this.buildCuratorFramework();
        boolean internalClient = !this.isUserSpecifiedCuratorFramework();
        return new ZooKeeperEndpointGroup(this.selectionStrategy, client, this.znodePath(), this.spec, internalClient);
    }

    @Override
    public ZooKeeperEndpointGroupBuilder connectTimeout(Duration connectTimeout) {
        return (ZooKeeperEndpointGroupBuilder)super.connectTimeout(connectTimeout);
    }

    @Override
    public ZooKeeperEndpointGroupBuilder connectTimeoutMillis(long connectTimeoutMillis) {
        return (ZooKeeperEndpointGroupBuilder)super.connectTimeoutMillis(connectTimeoutMillis);
    }

    @Override
    public ZooKeeperEndpointGroupBuilder sessionTimeout(Duration sessionTimeout) {
        return (ZooKeeperEndpointGroupBuilder)super.sessionTimeout(sessionTimeout);
    }

    @Override
    public ZooKeeperEndpointGroupBuilder sessionTimeoutMillis(long sessionTimeoutMillis) {
        return (ZooKeeperEndpointGroupBuilder)super.sessionTimeoutMillis(sessionTimeoutMillis);
    }

    @Override
    public ZooKeeperEndpointGroupBuilder customizer(Consumer<? super CuratorFrameworkFactory.Builder> customizer) {
        return (ZooKeeperEndpointGroupBuilder)super.customizer(customizer);
    }
}

