/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.internal.common.zookeeper;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.linecorp.armeria.client.endpoint.EndpointGroupException;
import java.io.IOException;
import java.util.Objects;
import org.apache.curator.x.discovery.ServiceInstance;

public enum CuratorXNodeValueCodec {
    INSTANCE;

    private static final ObjectMapper mapper;
    private static final JavaType type;

    public ServiceInstance<?> decode(byte[] znodeValue) {
        Objects.requireNonNull(znodeValue, "znodeValue");
        try {
            return (ServiceInstance)mapper.readValue(znodeValue, type);
        }
        catch (IOException e) {
            throw new EndpointGroupException("invalid endpoint segment.", (Throwable)e);
        }
    }

    public byte[] encode(ServiceInstance<?> serviceInstance) {
        try {
            return mapper.writeValueAsBytes(Objects.requireNonNull(serviceInstance, "serviceInstance"));
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException("Failed to encode serviceInstance. serviceInstance: " + serviceInstance, e);
        }
    }

    static {
        mapper = new ObjectMapper().configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        type = mapper.getTypeFactory().constructType(ServiceInstance.class);
    }
}

