/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.server.zookeeper;

import com.linecorp.armeria.internal.common.zookeeper.CuratorXNodeValueCodec;
import com.linecorp.armeria.internal.shaded.guava.base.MoreObjects;
import com.linecorp.armeria.server.zookeeper.ZooKeeperRegistrationSpec;
import org.apache.curator.x.discovery.ServiceInstance;

final class CuratorRegistrationSpec
implements ZooKeeperRegistrationSpec {
    private final ServiceInstance<?> serviceInstance;
    private final String path;

    CuratorRegistrationSpec(ServiceInstance<?> serviceInstance) {
        this.serviceInstance = serviceInstance;
        this.path = '/' + serviceInstance.getName() + '/' + serviceInstance.getId();
    }

    ServiceInstance<?> serviceInstance() {
        return this.serviceInstance;
    }

    @Override
    public String path() {
        return this.path;
    }

    @Override
    public boolean isSequential() {
        return false;
    }

    @Override
    public byte[] encodedInstance() {
        return CuratorXNodeValueCodec.INSTANCE.encode(this.serviceInstance);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("serviceInstance", this.serviceInstance).add("path", (Object)this.path).add("isSequential", this.isSequential()).toString();
    }
}

