/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.server.zookeeper;

import com.linecorp.armeria.client.Endpoint;
import com.linecorp.armeria.server.zookeeper.CuratorRegistrationSpecBuilder;
import com.linecorp.armeria.server.zookeeper.LegacyZooKeeperRegistrationSpec;
import com.linecorp.armeria.server.zookeeper.ServerSetsRegistrationSpecBuilder;
import java.util.Objects;

public interface ZooKeeperRegistrationSpec {
    public static ZooKeeperRegistrationSpec curator(String serviceName) {
        return new CuratorRegistrationSpecBuilder(serviceName).build();
    }

    public static CuratorRegistrationSpecBuilder builderForCurator(String serviceName) {
        return new CuratorRegistrationSpecBuilder(serviceName);
    }

    public static ZooKeeperRegistrationSpec serverSets() {
        return new ServerSetsRegistrationSpecBuilder().build();
    }

    public static ServerSetsRegistrationSpecBuilder builderForServerSets() {
        return new ServerSetsRegistrationSpecBuilder();
    }

    public static ZooKeeperRegistrationSpec legacy() {
        return new LegacyZooKeeperRegistrationSpec();
    }

    public static ZooKeeperRegistrationSpec legacy(Endpoint endpoint) {
        return new LegacyZooKeeperRegistrationSpec(Objects.requireNonNull(endpoint, "endpoint"));
    }

    public String path();

    public boolean isSequential();

    public byte[] encodedInstance();
}

