/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.server.zookeeper;

import com.linecorp.armeria.client.Endpoint;
import com.linecorp.armeria.common.SessionProtocol;
import com.linecorp.armeria.common.annotation.Nullable;
import com.linecorp.armeria.common.util.SystemInfo;
import com.linecorp.armeria.common.zookeeper.ServerSetsInstance;
import com.linecorp.armeria.server.Server;
import com.linecorp.armeria.server.ServerListenerAdapter;
import com.linecorp.armeria.server.ServerPort;
import com.linecorp.armeria.server.zookeeper.CuratorRegistrationSpec;
import com.linecorp.armeria.server.zookeeper.CuratorRegistrationSpecBuilder;
import com.linecorp.armeria.server.zookeeper.LegacyZooKeeperRegistrationSpec;
import com.linecorp.armeria.server.zookeeper.ServerSetsRegistrationSpec;
import com.linecorp.armeria.server.zookeeper.ServerSetsRegistrationSpecBuilder;
import com.linecorp.armeria.server.zookeeper.ZooKeeperRegistrationSpec;
import com.linecorp.armeria.server.zookeeper.ZooKeeperUpdatingListenerBuilder;
import java.net.Inet4Address;
import java.util.Objects;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.api.ACLBackgroundPathAndBytesable;
import org.apache.curator.framework.imps.CuratorFrameworkState;
import org.apache.curator.x.discovery.ServiceInstance;
import org.apache.zookeeper.CreateMode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ZooKeeperUpdatingListener
extends ServerListenerAdapter {
    private static final Logger logger = LoggerFactory.getLogger(ZooKeeperUpdatingListener.class);
    private final CuratorFramework client;
    private final String znodePath;
    private final ZooKeeperRegistrationSpec spec;
    private final boolean closeClientOnStop;

    public static ZooKeeperUpdatingListener of(String zkConnectionStr, String znodePath, ZooKeeperRegistrationSpec spec) {
        return ZooKeeperUpdatingListener.builder(zkConnectionStr, znodePath, spec).build();
    }

    public static ZooKeeperUpdatingListener of(CuratorFramework client, String znodePath, ZooKeeperRegistrationSpec spec) {
        return ZooKeeperUpdatingListener.builder(client, znodePath, spec).build();
    }

    public static ZooKeeperUpdatingListenerBuilder builder(CuratorFramework client, String znodePath, ZooKeeperRegistrationSpec spec) {
        return new ZooKeeperUpdatingListenerBuilder(client, znodePath, spec);
    }

    public static ZooKeeperUpdatingListenerBuilder builder(String zkConnectionStr, String znodePath, ZooKeeperRegistrationSpec spec) {
        return new ZooKeeperUpdatingListenerBuilder(zkConnectionStr, znodePath, spec);
    }

    ZooKeeperUpdatingListener(CuratorFramework client, String znodePath, ZooKeeperRegistrationSpec spec, boolean closeClientOnStop) {
        this.client = Objects.requireNonNull(client, "client");
        this.znodePath = Objects.requireNonNull(znodePath, "znodePath");
        this.spec = spec;
        this.closeClientOnStop = closeClientOnStop;
    }

    public void serverStarted(Server server) throws Exception {
        ZooKeeperRegistrationSpec registrationSpec = ZooKeeperUpdatingListener.fillAndCreateNewRegistrationSpec(this.spec, server);
        if (this.client.getState() != CuratorFrameworkState.STARTED) {
            this.client.start();
        }
        ((ACLBackgroundPathAndBytesable)this.client.create().creatingParentsIfNeeded().withMode(registrationSpec.isSequential() ? CreateMode.EPHEMERAL_SEQUENTIAL : CreateMode.EPHEMERAL)).forPath(this.znodePath + registrationSpec.path(), registrationSpec.encodedInstance());
    }

    private static ZooKeeperRegistrationSpec fillAndCreateNewRegistrationSpec(ZooKeeperRegistrationSpec spec, Server server) {
        if (spec instanceof LegacyZooKeeperRegistrationSpec) {
            return ZooKeeperUpdatingListener.legacySpec(spec, server);
        }
        if (spec instanceof CuratorRegistrationSpec) {
            return ZooKeeperUpdatingListener.curatorSpec(((CuratorRegistrationSpec)spec).serviceInstance(), server);
        }
        if (spec instanceof ServerSetsRegistrationSpec) {
            return ZooKeeperUpdatingListener.serverSetsSpec((ServerSetsRegistrationSpec)spec, server);
        }
        return spec;
    }

    private static ZooKeeperRegistrationSpec legacySpec(ZooKeeperRegistrationSpec spec, Server server) {
        Endpoint endpoint = ((LegacyZooKeeperRegistrationSpec)spec).endpoint();
        if (endpoint != null) {
            if (endpoint.hasPort()) {
                ZooKeeperUpdatingListener.warnIfInactivePort(server, endpoint.port(), null);
                return spec;
            }
            ServerPort serverPort = server.activePort();
            assert (serverPort != null);
            return ZooKeeperRegistrationSpec.legacy(endpoint.withPort(serverPort.localAddress().getPort()));
        }
        return ZooKeeperRegistrationSpec.legacy(ZooKeeperUpdatingListener.defaultEndpoint(server));
    }

    private static Endpoint defaultEndpoint(Server server) {
        ServerPort serverPort = server.activePort();
        assert (serverPort != null);
        return Endpoint.of((String)ZooKeeperUpdatingListener.defaultAddress(server), (int)serverPort.localAddress().getPort());
    }

    private static String defaultAddress(Server server) {
        Inet4Address inet4Address = SystemInfo.defaultNonLoopbackIpV4Address();
        return inet4Address != null ? inet4Address.getHostAddress() : server.defaultHostname();
    }

    private static ZooKeeperRegistrationSpec curatorSpec(ServiceInstance<?> serviceInstance, Server server) {
        int sslPort;
        CuratorRegistrationSpecBuilder builder = ZooKeeperRegistrationSpec.builderForCurator(serviceInstance.getName());
        builder.serviceId(serviceInstance.getId());
        String address = serviceInstance.getAddress() != null ? serviceInstance.getAddress() : ZooKeeperUpdatingListener.defaultAddress(server);
        builder.serviceAddress(address);
        int port = ZooKeeperUpdatingListener.port(server, SessionProtocol.HTTP, serviceInstance.getPort());
        if (port > 0) {
            builder.port(port);
        }
        if ((sslPort = ZooKeeperUpdatingListener.port(server, SessionProtocol.HTTPS, serviceInstance.getSslPort())) > 0) {
            builder.sslPort(sslPort);
        }
        builder.serviceType(serviceInstance.getServiceType());
        Object payload = serviceInstance.getPayload();
        if (payload != null) {
            builder.payload(payload);
        }
        return builder.build();
    }

    private static ZooKeeperRegistrationSpec serverSetsSpec(ServerSetsRegistrationSpec spec, Server server) {
        ServerSetsInstance serverSetsInstance = spec.serverSetsInstance();
        if (serverSetsInstance.serviceEndpoint() != null) {
            ZooKeeperUpdatingListener.warnIfInactivePort(server, serverSetsInstance.serviceEndpoint().port(), null);
            return spec;
        }
        ServerSetsRegistrationSpecBuilder builder = ZooKeeperRegistrationSpec.builderForServerSets();
        builder.serviceEndpoint(ZooKeeperUpdatingListener.defaultEndpoint(server)).additionalEndpoints(serverSetsInstance.additionalEndpoints()).metadata(serverSetsInstance.metadata()).sequential(spec.isSequential()).nodeName(spec.path().substring(1));
        Integer shardId = serverSetsInstance.shardId();
        if (shardId != null) {
            builder.shardId(shardId);
        }
        return builder.build();
    }

    private static int port(Server server, SessionProtocol protocol, @Nullable Integer port) {
        if (port != null) {
            ZooKeeperUpdatingListener.warnIfInactivePort(server, port, protocol);
            return port;
        }
        ServerPort serverPort = server.activePort(protocol);
        return serverPort != null ? serverPort.localAddress().getPort() : -1;
    }

    private static void warnIfInactivePort(Server server, int port, @Nullable SessionProtocol protocol) {
        for (ServerPort serverPort : server.activePorts().values()) {
            if (protocol != null && !serverPort.hasProtocol(protocol) || serverPort.localAddress().getPort() != port) continue;
            return;
        }
        logger.warn("The specified port number {} does not exist. (expected one of activePorts: {})", (Object)port, (Object)server.activePorts());
    }

    public void serverStopping(Server server) {
        if (this.closeClientOnStop) {
            this.client.close();
        }
    }
}

