/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.server.zookeeper;

import com.linecorp.armeria.common.zookeeper.AbstractCuratorFrameworkBuilder;
import com.linecorp.armeria.server.zookeeper.ZooKeeperRegistrationSpec;
import com.linecorp.armeria.server.zookeeper.ZooKeeperUpdatingListener;
import java.time.Duration;
import java.util.Objects;
import java.util.function.Consumer;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.CuratorFrameworkFactory;

public final class ZooKeeperUpdatingListenerBuilder
extends AbstractCuratorFrameworkBuilder {
    private final ZooKeeperRegistrationSpec spec;

    ZooKeeperUpdatingListenerBuilder(CuratorFramework client, String znodePath, ZooKeeperRegistrationSpec spec) {
        super(client, znodePath);
        this.spec = Objects.requireNonNull(spec, "spec");
    }

    ZooKeeperUpdatingListenerBuilder(String zkConnectionStr, String znodePath, ZooKeeperRegistrationSpec spec) {
        super(zkConnectionStr, znodePath);
        this.spec = Objects.requireNonNull(spec, "spec");
    }

    public ZooKeeperUpdatingListener build() {
        CuratorFramework client = this.buildCuratorFramework();
        boolean internalClient = !this.isUserSpecifiedCuratorFramework();
        return new ZooKeeperUpdatingListener(client, this.znodePath(), this.spec, internalClient);
    }

    @Override
    public ZooKeeperUpdatingListenerBuilder connectTimeout(Duration connectTimeout) {
        return (ZooKeeperUpdatingListenerBuilder)super.connectTimeout(connectTimeout);
    }

    @Override
    public ZooKeeperUpdatingListenerBuilder connectTimeoutMillis(long connectTimeoutMillis) {
        return (ZooKeeperUpdatingListenerBuilder)super.connectTimeoutMillis(connectTimeoutMillis);
    }

    @Override
    public ZooKeeperUpdatingListenerBuilder sessionTimeout(Duration sessionTimeout) {
        return (ZooKeeperUpdatingListenerBuilder)super.sessionTimeout(sessionTimeout);
    }

    @Override
    public ZooKeeperUpdatingListenerBuilder sessionTimeoutMillis(long sessionTimeoutMillis) {
        return (ZooKeeperUpdatingListenerBuilder)super.sessionTimeoutMillis(sessionTimeoutMillis);
    }

    @Override
    public ZooKeeperUpdatingListenerBuilder customizer(Consumer<? super CuratorFrameworkFactory.Builder> customizer) {
        return (ZooKeeperUpdatingListenerBuilder)super.customizer(customizer);
    }
}

