/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.client.zookeeper;

import com.linecorp.armeria.client.Endpoint;
import com.linecorp.armeria.client.zookeeper.ZooKeeperDiscoverySpec;
import com.linecorp.armeria.common.annotation.Nullable;
import com.linecorp.armeria.internal.common.zookeeper.CuratorXNodeValueCodec;
import com.linecorp.armeria.internal.shaded.guava.base.MoreObjects;
import java.util.function.Function;
import org.apache.curator.x.discovery.ServiceInstance;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class CuratorDiscoverySpec
implements ZooKeeperDiscoverySpec {
    private static final Logger logger = LoggerFactory.getLogger(CuratorDiscoverySpec.class);
    private final String path;
    private final Function<? super ServiceInstance<?>, @Nullable Endpoint> converter;

    CuratorDiscoverySpec(String serviceName, Function<? super ServiceInstance<?>, @Nullable Endpoint> converter) {
        this.path = '/' + serviceName;
        this.converter = converter;
    }

    @Override
    public String path() {
        return this.path;
    }

    @Override
    public Endpoint decode(byte[] data) {
        ServiceInstance<?> decodedInstance = CuratorXNodeValueCodec.INSTANCE.decode(data);
        Endpoint endpoint = this.converter.apply(decodedInstance);
        if (endpoint == null) {
            logger.warn("The endpoint converter returned null from {}.", decodedInstance);
        }
        return endpoint;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("path", (Object)this.path).add("converter", this.converter).toString();
    }
}

