/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.client.zookeeper;

import com.linecorp.armeria.client.Endpoint;
import com.linecorp.armeria.client.zookeeper.ZooKeeperDiscoverySpec;
import com.linecorp.armeria.common.zookeeper.ServerSetsInstance;
import com.linecorp.armeria.internal.common.zookeeper.ServerSetsNodeValueCodec;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class ServerSetsDiscoverySpec
implements ZooKeeperDiscoverySpec {
    private static final Logger logger = LoggerFactory.getLogger(ServerSetsDiscoverySpec.class);
    private final Function<? super ServerSetsInstance, Endpoint> converter;

    ServerSetsDiscoverySpec(Function<? super ServerSetsInstance, Endpoint> converter) {
        this.converter = converter;
    }

    @Override
    public String path() {
        return null;
    }

    @Override
    public Endpoint decode(byte[] data) {
        ServerSetsInstance decodedInstance = ServerSetsNodeValueCodec.INSTANCE.decode(data);
        if (decodedInstance.serviceEndpoint() == null) {
            return null;
        }
        Endpoint endpoint = this.converter.apply(decodedInstance);
        if (endpoint == null) {
            logger.warn("The endpoint converter returned null from {}.", (Object)decodedInstance);
        }
        return endpoint;
    }
}

