/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.common.zookeeper;

import com.linecorp.armeria.common.annotation.Nullable;
import com.linecorp.armeria.internal.shaded.guava.base.Preconditions;
import com.linecorp.armeria.internal.shaded.guava.collect.ImmutableList;
import com.linecorp.armeria.internal.shaded.guava.primitives.Ints;
import java.time.Duration;
import java.util.Objects;
import java.util.function.Consumer;
import org.apache.curator.RetryPolicy;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.CuratorFrameworkFactory;
import org.apache.curator.retry.ExponentialBackoffRetry;
import org.apache.zookeeper.common.PathUtils;

public class AbstractCuratorFrameworkBuilder {
    private static final int DEFAULT_CONNECT_TIMEOUT_MILLIS = 1000;
    private static final int DEFAULT_SESSION_TIMEOUT_MILLIS = 10000;
    private static final ExponentialBackoffRetry DEFAULT_RETRY_POLICY = new ExponentialBackoffRetry(1000, 3);
    @Nullable
    private final CuratorFramework client;
    private final String znodePath;
    @Nullable
    private final CuratorFrameworkFactory.Builder clientBuilder;
    @Nullable
    private final ImmutableList.Builder<Consumer<? super CuratorFrameworkFactory.Builder>> customizers;

    protected AbstractCuratorFrameworkBuilder(String zkConnectionStr, String znodePath) {
        Objects.requireNonNull(zkConnectionStr, "zkConnectionStr");
        Preconditions.checkArgument((!zkConnectionStr.isEmpty() ? 1 : 0) != 0, (Object)"zkConnectionStr can't be empty.");
        this.client = null;
        this.znodePath = AbstractCuratorFrameworkBuilder.validateZNodePath(znodePath);
        this.clientBuilder = CuratorFrameworkFactory.builder().connectString(zkConnectionStr).connectionTimeoutMs(1000).sessionTimeoutMs(10000).retryPolicy((RetryPolicy)DEFAULT_RETRY_POLICY);
        this.customizers = ImmutableList.builder();
    }

    protected AbstractCuratorFrameworkBuilder(CuratorFramework client, String znodePath) {
        this.client = Objects.requireNonNull(client, "client");
        this.znodePath = AbstractCuratorFrameworkBuilder.validateZNodePath(znodePath);
        this.clientBuilder = null;
        this.customizers = null;
    }

    private static String validateZNodePath(String znodePath) {
        try {
            PathUtils.validatePath((String)znodePath);
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException("znodePath: " + znodePath + " (reason: " + e.getMessage() + ')');
        }
        return znodePath;
    }

    protected final String znodePath() {
        return this.znodePath;
    }

    public AbstractCuratorFrameworkBuilder connectTimeout(Duration connectTimeout) {
        Objects.requireNonNull(connectTimeout, "connectTimeout");
        Preconditions.checkArgument((!connectTimeout.isZero() && !connectTimeout.isNegative() ? 1 : 0) != 0, (String)"connectTimeout: %s (expected: > 0)", (Object)connectTimeout);
        return this.connectTimeoutMillis(connectTimeout.toMillis());
    }

    public AbstractCuratorFrameworkBuilder connectTimeoutMillis(long connectTimeoutMillis) {
        Preconditions.checkArgument((connectTimeoutMillis > 0L ? 1 : 0) != 0, (String)"connectTimeoutMillis: %s (expected: > 0)", (long)connectTimeoutMillis);
        this.ensureInternalClient();
        this.customizer(builder -> builder.connectionTimeoutMs(Ints.saturatedCast((long)connectTimeoutMillis)));
        return this;
    }

    public AbstractCuratorFrameworkBuilder sessionTimeout(Duration sessionTimeout) {
        Objects.requireNonNull(sessionTimeout, "sessionTimeout");
        Preconditions.checkArgument((!sessionTimeout.isZero() && !sessionTimeout.isNegative() ? 1 : 0) != 0, (String)"sessionTimeout: %s (expected: > 0)", (Object)sessionTimeout);
        return this.sessionTimeoutMillis(sessionTimeout.toMillis());
    }

    public AbstractCuratorFrameworkBuilder sessionTimeoutMillis(long sessionTimeoutMillis) {
        Preconditions.checkArgument((sessionTimeoutMillis > 0L ? 1 : 0) != 0, (String)"sessionTimeoutMillis: %s (expected: > 0)", (long)sessionTimeoutMillis);
        this.ensureInternalClient();
        this.customizer(builder -> builder.sessionTimeoutMs(Ints.saturatedCast((long)sessionTimeoutMillis)));
        return this;
    }

    public AbstractCuratorFrameworkBuilder customizer(Consumer<? super CuratorFrameworkFactory.Builder> customizer) {
        this.ensureInternalClient();
        this.customizers.add(Objects.requireNonNull(customizer, "customizer"));
        return this;
    }

    protected final boolean isUserSpecifiedCuratorFramework() {
        return this.client != null;
    }

    private void ensureInternalClient() {
        Preconditions.checkState((this.client == null ? 1 : 0) != 0, (Object)"This method is allowed only when created with a connection string.");
    }

    protected final CuratorFramework buildCuratorFramework() {
        if (this.client != null) {
            return this.client;
        }
        this.customizers.build().forEach(c -> c.accept(this.clientBuilder));
        return this.clientBuilder.build();
    }
}

