/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.internal.common.zookeeper;

import com.linecorp.armeria.client.Endpoint;
import com.linecorp.armeria.client.endpoint.EndpointGroupException;
import java.nio.charset.StandardCharsets;
import java.util.Objects;

public enum LegacyNodeValueCodec {
    INSTANCE;

    private static final String fieldDelimiter = ":";

    public Endpoint decode(byte[] znodeValue) {
        Endpoint endpoint;
        Objects.requireNonNull(znodeValue, "znodeValue");
        String segment = new String(znodeValue, StandardCharsets.UTF_8);
        String[] tokens = segment.split(fieldDelimiter);
        switch (tokens.length) {
            case 1: {
                endpoint = Endpoint.of((String)segment);
                break;
            }
            case 2: {
                String host = tokens[0];
                int port = Integer.parseInt(tokens[1]);
                if (port == 0) {
                    endpoint = Endpoint.of((String)host);
                    break;
                }
                endpoint = Endpoint.of((String)host, (int)port);
                break;
            }
            case 3: {
                String host = tokens[0];
                int port = Integer.parseInt(tokens[1]);
                int weight = Integer.parseInt(tokens[2]);
                if (port == 0) {
                    endpoint = Endpoint.of((String)host).withWeight(weight);
                    break;
                }
                endpoint = Endpoint.of((String)host, (int)port).withWeight(weight);
                break;
            }
            default: {
                throw new EndpointGroupException("invalid endpoint segment: " + segment);
            }
        }
        return endpoint;
    }

    public byte[] encode(Endpoint endpoint) {
        Objects.requireNonNull(endpoint, "endpoint");
        String endpointStr = endpoint.hasPort() ? endpoint.host() + fieldDelimiter + endpoint.port() + fieldDelimiter + endpoint.weight() : endpoint.host();
        return endpointStr.getBytes(StandardCharsets.UTF_8);
    }
}

