/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.internal.common.zookeeper;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.linecorp.armeria.client.endpoint.EndpointGroupException;
import com.linecorp.armeria.common.zookeeper.ServerSetsInstance;
import java.io.IOException;
import java.util.Objects;

public enum ServerSetsNodeValueCodec {
    INSTANCE;

    private static final ObjectMapper mapper;
    private static final JavaType type;

    public ServerSetsInstance decode(byte[] znodeValue) {
        Objects.requireNonNull(znodeValue, "znodeValue");
        try {
            return (ServerSetsInstance)mapper.readValue(znodeValue, type);
        }
        catch (IOException e) {
            throw new EndpointGroupException("invalid endpoint segment.", (Throwable)e);
        }
    }

    public byte[] encode(ServerSetsInstance serverSetsInstance) {
        try {
            return mapper.writeValueAsBytes((Object)Objects.requireNonNull(serverSetsInstance, "serverSetsInstance"));
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException("Failed to encode serverSetsInstance. serverSetsInstance: " + serverSetsInstance, e);
        }
    }

    static {
        mapper = new ObjectMapper().configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        type = mapper.getTypeFactory().constructType(ServerSetsInstance.class);
    }
}

