/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.server.zookeeper;

import com.linecorp.armeria.client.Endpoint;
import com.linecorp.armeria.common.annotation.Nullable;
import com.linecorp.armeria.common.zookeeper.ServerSetsInstance;
import com.linecorp.armeria.internal.common.zookeeper.ZooKeeperPathUtil;
import com.linecorp.armeria.internal.shaded.guava.collect.ImmutableMap;
import com.linecorp.armeria.server.zookeeper.ServerSetsRegistrationSpec;
import com.linecorp.armeria.server.zookeeper.ZooKeeperRegistrationSpec;
import java.util.Map;
import java.util.Objects;

public final class ServerSetsRegistrationSpecBuilder {
    private static final String DEFAULT_NODE_NAME = "member_";
    @Nullable
    private Endpoint serviceEndpoint;
    private final ImmutableMap.Builder<String, Endpoint> additionalEndpointsBuilder = ImmutableMap.builder();
    @Nullable
    private Integer shardId;
    private Map<String, String> metadata = ImmutableMap.of();
    private String nodeName = "member_";
    private boolean sequential = true;

    ServerSetsRegistrationSpecBuilder() {
    }

    public ServerSetsRegistrationSpecBuilder serviceEndpoint(Endpoint serviceEndpoint) {
        this.serviceEndpoint = Objects.requireNonNull(serviceEndpoint, "serviceEndpoint");
        return this;
    }

    public ServerSetsRegistrationSpecBuilder additionalEndpoint(String name, Endpoint additionalEndpoint) {
        this.additionalEndpointsBuilder.put((Object)Objects.requireNonNull(name, "name"), (Object)Objects.requireNonNull(additionalEndpoint, "additionalEndpoint"));
        return this;
    }

    public ServerSetsRegistrationSpecBuilder additionalEndpoints(Map<String, Endpoint> additionalEndpoints) {
        Objects.requireNonNull(additionalEndpoints, "additionalEndpoints");
        this.additionalEndpointsBuilder.putAll(additionalEndpoints);
        return this;
    }

    public ServerSetsRegistrationSpecBuilder shardId(int shardId) {
        this.shardId = shardId;
        return this;
    }

    public ServerSetsRegistrationSpecBuilder metadata(Map<String, String> metadata) {
        this.metadata = ImmutableMap.copyOf(Objects.requireNonNull(metadata, "metadata"));
        return this;
    }

    public ServerSetsRegistrationSpecBuilder nodeName(String nodeName) {
        this.nodeName = ZooKeeperPathUtil.validatePath(nodeName, "nodeName");
        return this;
    }

    public ServerSetsRegistrationSpecBuilder sequential(boolean sequential) {
        this.sequential = sequential;
        return this;
    }

    public ZooKeeperRegistrationSpec build() {
        ServerSetsInstance serverSetsInstance = new ServerSetsInstance(this.serviceEndpoint, (Map<String, Endpoint>)this.additionalEndpointsBuilder.build(), this.shardId, this.metadata);
        return new ServerSetsRegistrationSpec(this.nodeName, this.sequential, serverSetsInstance);
    }
}

