/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.client.zookeeper;

import com.linecorp.armeria.client.Endpoint;
import com.linecorp.armeria.client.zookeeper.CuratorDiscoverySpec;
import com.linecorp.armeria.client.zookeeper.ZooKeeperDiscoverySpec;
import com.linecorp.armeria.internal.common.zookeeper.ZooKeeperPathUtil;
import com.linecorp.armeria.internal.shaded.guava.base.Preconditions;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nullable;
import org.apache.curator.x.discovery.ServiceInstance;

public final class CuratorDiscoverySpecBuilder {
    private final String serviceName;
    @Nullable
    private String instanceId;
    @Nullable
    private Boolean useSsl;
    @Nullable
    private Function<? super ServiceInstance<?>, Endpoint> converter;

    CuratorDiscoverySpecBuilder(String serviceName) {
        this.serviceName = ZooKeeperPathUtil.validatePath(serviceName, "serviceName");
    }

    public CuratorDiscoverySpecBuilder instanceId(String instanceId) {
        Preconditions.checkState((this.converter == null ? 1 : 0) != 0, (Object)"converter() and instanceId() are mutually exclusive.");
        this.instanceId = Objects.requireNonNull(instanceId, "instanceId");
        return this;
    }

    public CuratorDiscoverySpecBuilder useSsl(boolean useSsl) {
        Preconditions.checkState((this.converter == null ? 1 : 0) != 0, (Object)"converter() and useSsl() are mutually exclusive.");
        this.useSsl = useSsl;
        return this;
    }

    public CuratorDiscoverySpecBuilder converter(Function<? super ServiceInstance<?>, Endpoint> converter) {
        Preconditions.checkState((this.instanceId == null ? 1 : 0) != 0, (Object)"converter() and instanceId() are mutually exclusive.");
        Preconditions.checkState((this.useSsl == null ? 1 : 0) != 0, (Object)"converter() and useSsl() are mutually exclusive.");
        this.converter = Objects.requireNonNull(converter, "converter");
        return this;
    }

    private Function<? super ServiceInstance<?>, Endpoint> converter() {
        if (this.converter != null) {
            return this.converter;
        }
        return instance -> {
            if (!instance.isEnabled()) {
                return null;
            }
            if (this.instanceId != null && !this.instanceId.equals(instance.getId())) {
                return null;
            }
            if (this.useSsl != null && this.useSsl.booleanValue() && instance.getSslPort() != null) {
                return Endpoint.of((String)instance.getAddress(), (int)instance.getSslPort());
            }
            if (instance.getPort() != null) {
                return Endpoint.of((String)instance.getAddress(), (int)instance.getPort());
            }
            return Endpoint.of((String)instance.getAddress());
        };
    }

    public ZooKeeperDiscoverySpec build() {
        return new CuratorDiscoverySpec(this.serviceName, this.converter());
    }
}

