/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.client.zookeeper;

import com.linecorp.armeria.client.Endpoint;
import com.linecorp.armeria.client.zookeeper.CuratorDiscoverySpecBuilder;
import com.linecorp.armeria.client.zookeeper.LegacyZooKeeperDiscoverySpec;
import com.linecorp.armeria.client.zookeeper.ServerSetsDiscoverySpec;
import com.linecorp.armeria.common.zookeeper.ServerSetsInstance;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nullable;

public interface ZooKeeperDiscoverySpec {
    public static ZooKeeperDiscoverySpec curator(String serviceName) {
        return ZooKeeperDiscoverySpec.builderForCurator(serviceName).build();
    }

    public static CuratorDiscoverySpecBuilder builderForCurator(String serviceName) {
        return new CuratorDiscoverySpecBuilder(serviceName);
    }

    public static ZooKeeperDiscoverySpec serverSets() {
        return ZooKeeperDiscoverySpec.serverSets(ServerSetsInstance::serviceEndpoint);
    }

    public static ZooKeeperDiscoverySpec serverSets(Function<? super ServerSetsInstance, Endpoint> converter) {
        return new ServerSetsDiscoverySpec(Objects.requireNonNull(converter, "converter"));
    }

    public static ZooKeeperDiscoverySpec legacy() {
        return LegacyZooKeeperDiscoverySpec.INSTANCE;
    }

    @Nullable
    public String path();

    @Nullable
    public Endpoint decode(byte[] var1);
}

