/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.common.zookeeper;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.linecorp.armeria.client.Endpoint;
import com.linecorp.armeria.common.zookeeper.ServerSetsInstanceConverter;
import com.linecorp.armeria.internal.shaded.guava.base.MoreObjects;
import com.linecorp.armeria.internal.shaded.guava.base.Objects;
import com.linecorp.armeria.internal.shaded.guava.collect.ImmutableMap;
import java.util.Map;
import javax.annotation.Nullable;

@JsonSerialize(using=ServerSetsInstanceConverter.FinagleServiceInstanceSerializer.class)
@JsonDeserialize(using=ServerSetsInstanceConverter.FinagleServiceInstanceDeserializer.class)
public final class ServerSetsInstance {
    @Nullable
    private final Endpoint serviceEndpoint;
    private final Map<String, Endpoint> additionalEndpoints;
    @Nullable
    private final Integer shardId;
    private final Map<String, String> metadata;

    public ServerSetsInstance(@Nullable Endpoint serviceEndpoint, Map<String, Endpoint> additionalEndpoints, @Nullable Integer shardId, Map<String, String> metadata) {
        this.serviceEndpoint = serviceEndpoint;
        this.additionalEndpoints = ImmutableMap.copyOf(java.util.Objects.requireNonNull(additionalEndpoints, "additionalEndpoints"));
        this.shardId = shardId;
        this.metadata = ImmutableMap.copyOf(java.util.Objects.requireNonNull(metadata, "metadata"));
    }

    @Nullable
    public Endpoint serviceEndpoint() {
        return this.serviceEndpoint;
    }

    public Map<String, Endpoint> additionalEndpoints() {
        return this.additionalEndpoints;
    }

    @Nullable
    public Integer shardId() {
        return this.shardId;
    }

    public Map<String, String> metadata() {
        return this.metadata;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ServerSetsInstance)) {
            return false;
        }
        ServerSetsInstance that = (ServerSetsInstance)o;
        return Objects.equal((Object)this.serviceEndpoint, (Object)that.serviceEndpoint) && Objects.equal(this.additionalEndpoints, that.additionalEndpoints) && Objects.equal((Object)this.shardId, (Object)that.shardId) && Objects.equal(this.metadata, that.metadata);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.serviceEndpoint, this.additionalEndpoints, this.shardId, this.metadata});
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).omitNullValues().add("serviceEndpoint", (Object)this.serviceEndpoint).add("additionalEndpoints", this.additionalEndpoints).add("shardId", (Object)this.shardId).add("metadata", this.metadata).toString();
    }
}

