/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.common.zookeeper;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import com.linecorp.armeria.client.Endpoint;
import com.linecorp.armeria.common.zookeeper.ServerSetsInstance;
import com.linecorp.armeria.internal.shaded.guava.collect.ImmutableMap;
import java.io.IOException;
import java.util.Iterator;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class ServerSetsInstanceConverter {
    private static final String SERVICE_ENDPOINT = "serviceEndpoint";
    private static final String HOST = "host";
    private static final String PORT = "port";
    private static final String ADDITIONAL_ENDPOINTS = "additionalEndpoints";
    private static final String STATUS = "status";
    private static final String ALIVE = "ALIVE";
    private static final String SHARD = "shard";
    private static final String METADATA = "metadata";

    private ServerSetsInstanceConverter() {
    }

    static final class FinagleServiceInstanceDeserializer
    extends StdDeserializer<ServerSetsInstance> {
        private static final long serialVersionUID = 3445603112141405710L;
        private static final Logger logger = LoggerFactory.getLogger(FinagleServiceInstanceDeserializer.class);
        private static final ServerSetsInstance notAliveInstance = new ServerSetsInstance(null, (Map<String, Endpoint>)ImmutableMap.of(), null, (Map<String, String>)ImmutableMap.of());

        FinagleServiceInstanceDeserializer() {
            super(ServerSetsInstance.class);
        }

        public ServerSetsInstance deserialize(JsonParser p, DeserializationContext ctxt) throws IOException, JsonProcessingException {
            JsonNode tree = (JsonNode)p.getCodec().readTree(p);
            JsonNode serviceEndpointNode = tree.get(ServerSetsInstanceConverter.SERVICE_ENDPOINT);
            Endpoint serviceEndpoint = FinagleServiceInstanceDeserializer.endpoint(serviceEndpointNode);
            String status = tree.get(ServerSetsInstanceConverter.STATUS).asText();
            if (!ServerSetsInstanceConverter.ALIVE.equals(status)) {
                logger.warn("Found an instance whose status is not alive. status: {}, serviceEndpoint: {}", (Object)status, (Object)serviceEndpoint);
                return notAliveInstance;
            }
            ImmutableMap.Builder additionalsBuilder = ImmutableMap.builder();
            Iterator additionals = tree.get(ServerSetsInstanceConverter.ADDITIONAL_ENDPOINTS).fields();
            while (additionals.hasNext()) {
                Map.Entry next = (Map.Entry)additionals.next();
                additionalsBuilder.put((Object)((String)next.getKey()), (Object)FinagleServiceInstanceDeserializer.endpoint((JsonNode)next.getValue()));
            }
            JsonNode shardNode = tree.get(ServerSetsInstanceConverter.SHARD);
            Integer shardId = shardNode == null ? null : Integer.valueOf(shardNode.asInt());
            ImmutableMap.Builder metadataBuilder = ImmutableMap.builder();
            JsonNode metadataNode = tree.get(ServerSetsInstanceConverter.METADATA);
            if (metadataNode != null) {
                Iterator fields = metadataNode.fields();
                while (fields.hasNext()) {
                    Map.Entry next = (Map.Entry)fields.next();
                    metadataBuilder.put((Object)((String)next.getKey()), (Object)((JsonNode)next.getValue()).asText());
                }
            }
            return new ServerSetsInstance(serviceEndpoint, (Map<String, Endpoint>)additionalsBuilder.build(), shardId, (Map<String, String>)metadataBuilder.build());
        }

        private static Endpoint endpoint(JsonNode serviceEndpointNode) {
            return Endpoint.of((String)serviceEndpointNode.get(ServerSetsInstanceConverter.HOST).asText(), (int)serviceEndpointNode.get(ServerSetsInstanceConverter.PORT).asInt());
        }
    }

    static final class FinagleServiceInstanceSerializer
    extends StdSerializer<ServerSetsInstance> {
        private static final long serialVersionUID = 4497981752858570527L;

        FinagleServiceInstanceSerializer() {
            super(ServerSetsInstance.class);
        }

        public void serialize(ServerSetsInstance value, JsonGenerator gen, SerializerProvider provider) throws IOException {
            gen.writeStartObject();
            gen.writeObjectFieldStart(ServerSetsInstanceConverter.SERVICE_ENDPOINT);
            Endpoint serviceEndpoint = value.serviceEndpoint();
            assert (serviceEndpoint != null);
            FinagleServiceInstanceSerializer.writeEndpoint(gen, serviceEndpoint);
            gen.writeEndObject();
            gen.writeObjectFieldStart(ServerSetsInstanceConverter.ADDITIONAL_ENDPOINTS);
            for (Map.Entry<String, Endpoint> additionalEndpoint : value.additionalEndpoints().entrySet()) {
                gen.writeObjectFieldStart(additionalEndpoint.getKey());
                FinagleServiceInstanceSerializer.writeEndpoint(gen, additionalEndpoint.getValue());
                gen.writeEndObject();
            }
            gen.writeEndObject();
            gen.writeStringField(ServerSetsInstanceConverter.STATUS, ServerSetsInstanceConverter.ALIVE);
            Integer shardId = value.shardId();
            if (shardId != null) {
                gen.writeNumberField(ServerSetsInstanceConverter.SHARD, shardId.intValue());
            }
            Map<String, String> metadata = value.metadata();
            gen.writeFieldName(ServerSetsInstanceConverter.METADATA);
            gen.writeStartObject();
            if (!metadata.isEmpty()) {
                for (Map.Entry<String, String> entry : metadata.entrySet()) {
                    gen.writeStringField(entry.getKey(), entry.getValue());
                }
            }
            gen.writeEndObject();
            gen.writeEndObject();
        }

        private static void writeEndpoint(JsonGenerator gen, Endpoint serviceEndpoint) throws IOException {
            gen.writeStringField(ServerSetsInstanceConverter.HOST, serviceEndpoint.host());
            gen.writeNumberField(ServerSetsInstanceConverter.PORT, serviceEndpoint.port());
        }
    }
}

