/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.server.zookeeper;

import com.linecorp.armeria.internal.common.zookeeper.ZooKeeperPathUtil;
import com.linecorp.armeria.internal.shaded.guava.base.Preconditions;
import com.linecorp.armeria.server.zookeeper.CuratorRegistrationSpec;
import com.linecorp.armeria.server.zookeeper.ZooKeeperRegistrationSpec;
import java.util.Objects;
import java.util.UUID;
import javax.annotation.Nullable;
import org.apache.curator.x.discovery.ServiceInstance;
import org.apache.curator.x.discovery.ServiceType;
import org.apache.curator.x.discovery.UriSpec;

public final class CuratorRegistrationSpecBuilder {
    private final String serviceName;
    @Nullable
    private String serviceId;
    @Nullable
    private String serviceAddress;
    @Nullable
    private Integer port;
    @Nullable
    private Integer sslPort;
    private ServiceType serviceType = ServiceType.DYNAMIC;
    @Nullable
    private Object payload;
    private UriSpec uriSpec = new UriSpec("{scheme}://{address}:{port}");

    CuratorRegistrationSpecBuilder(String serviceName) {
        this.serviceName = ZooKeeperPathUtil.validatePath(serviceName, "serviceName");
    }

    public CuratorRegistrationSpecBuilder serviceAddress(String serviceAddress) {
        this.serviceAddress = Objects.requireNonNull(serviceAddress, "serviceAddress");
        return this;
    }

    public CuratorRegistrationSpecBuilder port(int port) {
        Preconditions.checkArgument((port > 0 ? 1 : 0) != 0, (String)"port: %s (expected: > 0)", (int)port);
        this.port = port;
        return this;
    }

    public CuratorRegistrationSpecBuilder sslPort(int sslPort) {
        Preconditions.checkArgument((sslPort > 0 ? 1 : 0) != 0, (String)"sslPort: %s (expected: > 0)", (int)sslPort);
        this.sslPort = sslPort;
        return this;
    }

    public CuratorRegistrationSpecBuilder serviceId(String serviceId) {
        this.serviceId = ZooKeeperPathUtil.validatePath(serviceId, "serviceId");
        return this;
    }

    public <T> CuratorRegistrationSpecBuilder payload(T payload) {
        this.payload = Objects.requireNonNull(payload, "payload");
        return this;
    }

    public CuratorRegistrationSpecBuilder serviceType(ServiceType serviceType) {
        this.serviceType = Objects.requireNonNull(serviceType, "serviceType");
        return this;
    }

    public CuratorRegistrationSpecBuilder uriSpec(UriSpec uriSpec) {
        this.uriSpec = Objects.requireNonNull(uriSpec, "uriSpec");
        return this;
    }

    public ZooKeeperRegistrationSpec build() {
        String serviceId = this.serviceId != null ? this.serviceId : UUID.randomUUID().toString();
        ServiceInstance serviceInstance = new ServiceInstance(this.serviceName, serviceId, this.serviceAddress, this.port, this.sslPort, this.payload, System.currentTimeMillis(), this.serviceType, this.uriSpec);
        return new CuratorRegistrationSpec(serviceInstance);
    }
}

