/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.server.zookeeper;

import com.linecorp.armeria.client.Endpoint;
import com.linecorp.armeria.internal.common.zookeeper.LegacyNodeValueCodec;
import com.linecorp.armeria.internal.common.zookeeper.ZooKeeperPathUtil;
import com.linecorp.armeria.internal.shaded.guava.base.MoreObjects;
import com.linecorp.armeria.server.zookeeper.ZooKeeperRegistrationSpec;
import javax.annotation.Nullable;

final class LegacyZooKeeperRegistrationSpec
implements ZooKeeperRegistrationSpec {
    private static final byte[] EMPTY_BYTE = new byte[0];
    @Nullable
    private final Endpoint endpoint;
    private final String path;

    LegacyZooKeeperRegistrationSpec() {
        this(null);
    }

    LegacyZooKeeperRegistrationSpec(@Nullable Endpoint endpoint) {
        this.endpoint = endpoint;
        if (endpoint != null) {
            ZooKeeperPathUtil.validatePath(endpoint.host(), "endpoint.host()");
            this.path = '/' + endpoint.host() + '_' + endpoint.port();
        } else {
            this.path = "/";
        }
    }

    @Nullable
    Endpoint endpoint() {
        return this.endpoint;
    }

    @Override
    public String path() {
        return this.path;
    }

    @Override
    public boolean isSequential() {
        return false;
    }

    @Override
    public byte[] encodedInstance() {
        if (this.endpoint == null) {
            return EMPTY_BYTE;
        }
        return LegacyNodeValueCodec.INSTANCE.encode(this.endpoint);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).omitNullValues().add("endpoint", (Object)this.endpoint).add("path", (Object)this.path).add("isSequential", this.isSequential()).toString();
    }
}

