/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.server.zookeeper;

import com.linecorp.armeria.common.zookeeper.ServerSetsInstance;
import com.linecorp.armeria.internal.common.zookeeper.ServerSetsNodeValueCodec;
import com.linecorp.armeria.internal.shaded.guava.base.MoreObjects;
import com.linecorp.armeria.server.zookeeper.ZooKeeperRegistrationSpec;

final class ServerSetsRegistrationSpec
implements ZooKeeperRegistrationSpec {
    private final String path;
    private final boolean isSequential;
    private final ServerSetsInstance serverSetsInstance;

    ServerSetsRegistrationSpec(String nodeName, boolean isSequential, ServerSetsInstance serverSetsInstance) {
        this.path = '/' + nodeName;
        this.isSequential = isSequential;
        this.serverSetsInstance = serverSetsInstance;
    }

    ServerSetsInstance serverSetsInstance() {
        return this.serverSetsInstance;
    }

    @Override
    public String path() {
        return this.path;
    }

    @Override
    public boolean isSequential() {
        return this.isSequential;
    }

    @Override
    public byte[] encodedInstance() {
        return ServerSetsNodeValueCodec.INSTANCE.encode(this.serverSetsInstance);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("serverSetsInstance", (Object)this.serverSetsInstance).add("path", (Object)this.path).add("isSequential", this.isSequential).toString();
    }
}

