/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.bot.client;

import com.linecorp.bot.client.ChannelTokenSupplier;
import java.io.IOException;
import okhttp3.Interceptor;
import okhttp3.Request;
import okhttp3.Response;

class HeaderInterceptor
implements Interceptor {
    private static final String USER_AGENT = "line-botsdk-java/" + HeaderInterceptor.class.getPackage().getImplementationVersion();
    private final ChannelTokenSupplier channelTokenSupplier;

    public Response intercept(Interceptor.Chain chain) throws IOException {
        String channelToken = (String)this.channelTokenSupplier.get();
        Request request = chain.request().newBuilder().addHeader("Authorization", "Bearer " + channelToken).addHeader("User-Agent", USER_AGENT).build();
        return chain.proceed(request);
    }

    private HeaderInterceptor(ChannelTokenSupplier channelTokenSupplier) {
        this.channelTokenSupplier = channelTokenSupplier;
    }

    public static HeaderInterceptor forChannelTokenSupplier(ChannelTokenSupplier channelTokenSupplier) {
        return new HeaderInterceptor(channelTokenSupplier);
    }
}

