/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.bot.client;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.linecorp.bot.client.ChannelTokenSupplier;
import com.linecorp.bot.client.FixedChannelTokenSupplier;
import com.linecorp.bot.client.HeaderInterceptor;
import com.linecorp.bot.client.LineBlobClient;
import com.linecorp.bot.client.LineBlobClientImpl;
import com.linecorp.bot.client.LineBlobService;
import com.linecorp.bot.client.LineClientConstants;
import com.linecorp.bot.client.LineMessagingClient;
import com.linecorp.bot.client.LineMessagingClientImpl;
import com.linecorp.bot.client.LineMessagingService;
import com.linecorp.bot.model.objectmapper.ModelObjectMapper;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import lombok.NonNull;
import okhttp3.Interceptor;
import okhttp3.OkHttpClient;
import okhttp3.logging.HttpLoggingInterceptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import retrofit2.Converter;
import retrofit2.Retrofit;
import retrofit2.converter.jackson.JacksonConverterFactory;

public class LineMessagingClientBuilder {
    private static final ObjectMapper objectMapper = ModelObjectMapper.createNewObjectMapper();
    private URI apiEndPoint = LineClientConstants.DEFAULT_API_END_POINT;
    private URI blobEndPoint = LineClientConstants.DEFAULT_BLOB_END_POINT;
    private long connectTimeout = 10000L;
    private long readTimeout = 10000L;
    private long writeTimeout = 10000L;
    private ChannelTokenSupplier channelTokenSupplier;
    private Retrofit.Builder retrofitBuilder;
    private boolean addAuthenticationHeader = true;
    private OkHttpClient.Builder okHttpClientBuilder;
    private List<Interceptor> additionalInterceptors = new ArrayList<Interceptor>();

    LineMessagingClientBuilder() {
    }

    @Deprecated
    public LineMessagingClientBuilder apiEndPoint(String apiEndPoint) {
        return this.apiEndPoint(URI.create(apiEndPoint));
    }

    public LineMessagingClientBuilder apiEndPoint(URI apiEndPoint) {
        this.apiEndPoint = Objects.requireNonNull(apiEndPoint, "apiEndPoint");
        return this;
    }

    public LineMessagingClientBuilder channelToken(String channelToken) {
        this.channelTokenSupplier(FixedChannelTokenSupplier.of(channelToken));
        return this;
    }

    public LineMessagingClientBuilder okHttpClientBuilder(@NonNull OkHttpClient.Builder okHttpClientBuilder, boolean addAuthenticationHeader) {
        if (okHttpClientBuilder == null) {
            throw new NullPointerException("okHttpClientBuilder is marked non-null but is null");
        }
        this.okHttpClientBuilder = okHttpClientBuilder;
        this.addAuthenticationHeader = addAuthenticationHeader;
        return this;
    }

    <T> T buildRetrofitIface(URI apiEndPoint, Class<T> retrofitIFace) {
        if (this.okHttpClientBuilder == null) {
            this.okHttpClientBuilder = new OkHttpClient.Builder();
        }
        if (this.addAuthenticationHeader) {
            this.okHttpClientBuilder.addInterceptor((Interceptor)LineMessagingClientBuilder.buildAuthenticationInterceptor(this.channelTokenSupplier));
        }
        if (this.additionalInterceptors != null) {
            this.additionalInterceptors.forEach(arg_0 -> ((OkHttpClient.Builder)this.okHttpClientBuilder).addInterceptor(arg_0));
        }
        this.okHttpClientBuilder.addInterceptor(LineMessagingClientBuilder.buildLoggingInterceptor());
        this.okHttpClientBuilder.connectTimeout(this.connectTimeout, TimeUnit.MILLISECONDS).readTimeout(this.readTimeout, TimeUnit.MILLISECONDS).writeTimeout(this.writeTimeout, TimeUnit.MILLISECONDS);
        OkHttpClient okHttpClient = this.okHttpClientBuilder.build();
        if (this.retrofitBuilder == null) {
            this.retrofitBuilder = LineMessagingClientBuilder.createDefaultRetrofitBuilder();
        }
        this.retrofitBuilder.client(okHttpClient);
        this.retrofitBuilder.baseUrl(apiEndPoint.toString());
        Retrofit retrofit = this.retrofitBuilder.build();
        return (T)retrofit.create(retrofitIFace);
    }

    static HeaderInterceptor buildAuthenticationInterceptor(ChannelTokenSupplier channelTokenSupplier) {
        Objects.requireNonNull(channelTokenSupplier, "channelTokenSupplier");
        return HeaderInterceptor.forChannelTokenSupplier(channelTokenSupplier);
    }

    static Interceptor buildLoggingInterceptor() {
        Logger slf4jLogger = LoggerFactory.getLogger((String)"com.linecorp.bot.client.wire");
        return new HttpLoggingInterceptor(arg_0 -> ((Logger)slf4jLogger).info(arg_0)).setLevel(HttpLoggingInterceptor.Level.BODY);
    }

    static Retrofit.Builder createDefaultRetrofitBuilder() {
        return new Retrofit.Builder().addConverterFactory((Converter.Factory)JacksonConverterFactory.create((ObjectMapper)objectMapper));
    }

    public LineMessagingClient build() {
        return new LineMessagingClientImpl(this.buildRetrofitIface(this.apiEndPoint, LineMessagingService.class), this.buildBlobClient());
    }

    private LineBlobClient buildBlobClient() {
        return new LineBlobClientImpl(this.buildRetrofitIface(this.blobEndPoint, LineBlobService.class));
    }

    public String toString() {
        return "LineMessagingClientBuilder(apiEndPoint=" + this.apiEndPoint + ", blobEndPoint=" + this.blobEndPoint + ", connectTimeout=" + this.connectTimeout + ", readTimeout=" + this.readTimeout + ", writeTimeout=" + this.writeTimeout + ", channelTokenSupplier=" + this.channelTokenSupplier + ", retrofitBuilder=" + this.retrofitBuilder + ", addAuthenticationHeader=" + this.addAuthenticationHeader + ", okHttpClientBuilder=" + this.okHttpClientBuilder + ", additionalInterceptors=" + this.additionalInterceptors + ")";
    }

    public LineMessagingClientBuilder blobEndPoint(URI blobEndPoint) {
        this.blobEndPoint = blobEndPoint;
        return this;
    }

    public LineMessagingClientBuilder connectTimeout(long connectTimeout) {
        this.connectTimeout = connectTimeout;
        return this;
    }

    public LineMessagingClientBuilder readTimeout(long readTimeout) {
        this.readTimeout = readTimeout;
        return this;
    }

    public LineMessagingClientBuilder writeTimeout(long writeTimeout) {
        this.writeTimeout = writeTimeout;
        return this;
    }

    public LineMessagingClientBuilder channelTokenSupplier(ChannelTokenSupplier channelTokenSupplier) {
        this.channelTokenSupplier = channelTokenSupplier;
        return this;
    }

    public LineMessagingClientBuilder retrofitBuilder(Retrofit.Builder retrofitBuilder) {
        this.retrofitBuilder = retrofitBuilder;
        return this;
    }

    public LineMessagingClientBuilder addAuthenticationHeader(boolean addAuthenticationHeader) {
        this.addAuthenticationHeader = addAuthenticationHeader;
        return this;
    }

    public LineMessagingClientBuilder additionalInterceptors(List<Interceptor> additionalInterceptors) {
        this.additionalInterceptors = additionalInterceptors;
        return this;
    }
}

