/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.bot.client;

import com.linecorp.bot.client.BotApiResponseBody;
import com.linecorp.bot.client.ExceptionConverter;
import com.linecorp.bot.client.LineBlobClient;
import com.linecorp.bot.client.LineMessagingClient;
import com.linecorp.bot.client.LineMessagingService;
import com.linecorp.bot.client.MessageContentResponse;
import com.linecorp.bot.client.exception.GeneralLineMessagingException;
import com.linecorp.bot.model.Broadcast;
import com.linecorp.bot.model.Multicast;
import com.linecorp.bot.model.PushMessage;
import com.linecorp.bot.model.ReplyMessage;
import com.linecorp.bot.model.profile.MembersIdsResponse;
import com.linecorp.bot.model.profile.UserProfileResponse;
import com.linecorp.bot.model.response.BotApiResponse;
import com.linecorp.bot.model.response.GetNumberOfFollowersResponse;
import com.linecorp.bot.model.response.GetNumberOfMessageDeliveriesResponse;
import com.linecorp.bot.model.response.IssueLinkTokenResponse;
import com.linecorp.bot.model.response.MessageQuotaResponse;
import com.linecorp.bot.model.response.NumberOfMessagesResponse;
import com.linecorp.bot.model.response.QuotaConsumptionResponse;
import com.linecorp.bot.model.response.demographics.GetFriendsDemographicsResponse;
import com.linecorp.bot.model.richmenu.RichMenu;
import com.linecorp.bot.model.richmenu.RichMenuBulkLinkRequest;
import com.linecorp.bot.model.richmenu.RichMenuBulkUnlinkRequest;
import com.linecorp.bot.model.richmenu.RichMenuIdResponse;
import com.linecorp.bot.model.richmenu.RichMenuListResponse;
import com.linecorp.bot.model.richmenu.RichMenuResponse;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import retrofit2.Call;
import retrofit2.Callback;
import retrofit2.Response;

public class LineMessagingClientImpl
implements LineMessagingClient {
    private static final Logger log = LoggerFactory.getLogger(LineMessagingClientImpl.class);
    static final ExceptionConverter EXCEPTION_CONVERTER = new ExceptionConverter();
    private static final String ORG_TYPE_GROUP = "group";
    private static final String ORG_TYPE_ROOM = "room";
    private static final BotApiResponseBody BOT_API_SUCCESS_RESPONSE_BODY = BotApiResponseBody.builder().message("").details(Collections.emptyList()).build();
    private final LineMessagingService retrofitImpl;
    private final LineBlobClient blobDelegationTarget;

    @Override
    public CompletableFuture<BotApiResponse> replyMessage(ReplyMessage replyMessage) {
        return LineMessagingClientImpl.toBotApiResponseFuture(this.retrofitImpl.replyMessage(replyMessage));
    }

    @Override
    public CompletableFuture<BotApiResponse> pushMessage(PushMessage pushMessage) {
        return LineMessagingClientImpl.toBotApiResponseFuture(this.retrofitImpl.pushMessage(pushMessage));
    }

    @Override
    public CompletableFuture<BotApiResponse> multicast(Multicast multicast) {
        return LineMessagingClientImpl.toBotApiResponseFuture(this.retrofitImpl.multicast(multicast));
    }

    @Override
    public CompletableFuture<BotApiResponse> broadcast(Broadcast broadcast) {
        return LineMessagingClientImpl.toBotApiResponseFuture(this.retrofitImpl.broadcast(broadcast));
    }

    @Override
    public CompletableFuture<MessageContentResponse> getMessageContent(String messageId) {
        return this.blobDelegationTarget.getMessageContent(messageId);
    }

    @Override
    public CompletableFuture<MessageQuotaResponse> getMessageQuota() {
        return LineMessagingClientImpl.toFuture(this.retrofitImpl.getMessageQuota());
    }

    @Override
    public CompletableFuture<QuotaConsumptionResponse> getMessageQuotaConsumption() {
        return LineMessagingClientImpl.toFuture(this.retrofitImpl.getMessageQuotaConsumption());
    }

    @Override
    public CompletableFuture<NumberOfMessagesResponse> getNumberOfSentReplyMessages(String date) {
        return LineMessagingClientImpl.toFuture(this.retrofitImpl.getNumberOfSentReplyMessages(date));
    }

    @Override
    public CompletableFuture<NumberOfMessagesResponse> getNumberOfSentPushMessages(String date) {
        return LineMessagingClientImpl.toFuture(this.retrofitImpl.getNumberOfSentPushMessages(date));
    }

    @Override
    public CompletableFuture<NumberOfMessagesResponse> getNumberOfSentMulticastMessages(String date) {
        return LineMessagingClientImpl.toFuture(this.retrofitImpl.getNumberOfSentMulticastMessages(date));
    }

    @Override
    public CompletableFuture<NumberOfMessagesResponse> getNumberOfSentBroadcastMessages(String date) {
        return LineMessagingClientImpl.toFuture(this.retrofitImpl.getNumberOfSentBroadcastMessages(date));
    }

    @Override
    public CompletableFuture<UserProfileResponse> getProfile(String userId) {
        return LineMessagingClientImpl.toFuture(this.retrofitImpl.getProfile(userId));
    }

    @Override
    public CompletableFuture<UserProfileResponse> getGroupMemberProfile(String groupId, String userId) {
        return LineMessagingClientImpl.toFuture(this.retrofitImpl.getMemberProfile(ORG_TYPE_GROUP, groupId, userId));
    }

    @Override
    public CompletableFuture<UserProfileResponse> getRoomMemberProfile(String roomId, String userId) {
        return LineMessagingClientImpl.toFuture(this.retrofitImpl.getMemberProfile(ORG_TYPE_ROOM, roomId, userId));
    }

    @Override
    public CompletableFuture<MembersIdsResponse> getGroupMembersIds(String groupId, String start) {
        return LineMessagingClientImpl.toFuture(this.retrofitImpl.getMembersIds(ORG_TYPE_GROUP, groupId, start));
    }

    @Override
    public CompletableFuture<MembersIdsResponse> getRoomMembersIds(String roomId, String start) {
        return LineMessagingClientImpl.toFuture(this.retrofitImpl.getMembersIds(ORG_TYPE_ROOM, roomId, start));
    }

    @Override
    public CompletableFuture<BotApiResponse> leaveGroup(String groupId) {
        return LineMessagingClientImpl.toBotApiResponseFuture(this.retrofitImpl.leaveGroup(groupId));
    }

    @Override
    public CompletableFuture<BotApiResponse> leaveRoom(String roomId) {
        return LineMessagingClientImpl.toBotApiResponseFuture(this.retrofitImpl.leaveRoom(roomId));
    }

    @Override
    public CompletableFuture<RichMenuResponse> getRichMenu(String richMenuId) {
        return LineMessagingClientImpl.toFuture(this.retrofitImpl.getRichMenu(richMenuId));
    }

    @Override
    public CompletableFuture<RichMenuIdResponse> createRichMenu(RichMenu richMenu) {
        return LineMessagingClientImpl.toFuture(this.retrofitImpl.createRichMenu(richMenu));
    }

    @Override
    public CompletableFuture<BotApiResponse> deleteRichMenu(String richMenuId) {
        return LineMessagingClientImpl.toBotApiFuture(this.retrofitImpl.deleteRichMenu(richMenuId));
    }

    @Override
    public CompletableFuture<RichMenuIdResponse> getRichMenuIdOfUser(String userId) {
        return LineMessagingClientImpl.toFuture(this.retrofitImpl.getRichMenuIdOfUser(userId));
    }

    @Override
    public CompletableFuture<BotApiResponse> linkRichMenuIdToUser(String userId, String richMenuId) {
        return LineMessagingClientImpl.toBotApiFuture(this.retrofitImpl.linkRichMenuToUser(userId, richMenuId));
    }

    @Override
    public CompletableFuture<BotApiResponse> linkRichMenuIdToUsers(List<String> userIds, String richMenuId) {
        return LineMessagingClientImpl.toBotApiFuture(this.retrofitImpl.linkRichMenuToUsers(RichMenuBulkLinkRequest.builder().richMenuId(richMenuId).userIds(userIds).build()));
    }

    @Override
    public CompletableFuture<BotApiResponse> unlinkRichMenuIdFromUser(String userId) {
        return LineMessagingClientImpl.toBotApiFuture(this.retrofitImpl.unlinkRichMenuIdFromUser(userId));
    }

    @Override
    public CompletableFuture<BotApiResponse> unlinkRichMenuIdFromUsers(List<String> userIds) {
        return LineMessagingClientImpl.toBotApiFuture(this.retrofitImpl.unlinkRichMenuIdFromUsers(RichMenuBulkUnlinkRequest.builder().userIds(userIds).build()));
    }

    @Override
    public CompletableFuture<MessageContentResponse> getRichMenuImage(String richMenuId) {
        return this.blobDelegationTarget.getRichMenuImage(richMenuId);
    }

    @Override
    public CompletableFuture<BotApiResponse> setRichMenuImage(String richMenuId, String contentType, byte[] content) {
        return this.blobDelegationTarget.setRichMenuImage(richMenuId, contentType, content);
    }

    @Override
    public CompletableFuture<RichMenuListResponse> getRichMenuList() {
        return LineMessagingClientImpl.toFuture(this.retrofitImpl.getRichMenuList());
    }

    @Override
    public CompletableFuture<BotApiResponse> setDefaultRichMenu(String richMenuId) {
        return LineMessagingClientImpl.toBotApiFuture(this.retrofitImpl.setDefaultRichMenu(richMenuId));
    }

    @Override
    public CompletableFuture<RichMenuIdResponse> getDefaultRichMenuId() {
        return LineMessagingClientImpl.toFuture(this.retrofitImpl.getDefaultRichMenuId());
    }

    @Override
    public CompletableFuture<BotApiResponse> cancelDefaultRichMenu() {
        return LineMessagingClientImpl.toBotApiFuture(this.retrofitImpl.cancelDefaultRichMenu());
    }

    @Override
    public CompletableFuture<IssueLinkTokenResponse> issueLinkToken(String userId) {
        return LineMessagingClientImpl.toFuture(this.retrofitImpl.issueLinkToken(userId));
    }

    @Override
    public CompletableFuture<GetFriendsDemographicsResponse> getFriendsDemographics() {
        return LineMessagingClientImpl.toFuture(this.retrofitImpl.getFriendsDemographics());
    }

    @Override
    public CompletableFuture<GetNumberOfMessageDeliveriesResponse> getNumberOfMessageDeliveries(String date) {
        return LineMessagingClientImpl.toFuture(this.retrofitImpl.getNumberOfMessageDeliveries(date));
    }

    @Override
    public CompletableFuture<GetNumberOfFollowersResponse> getNumberOfFollowers(String date) {
        return LineMessagingClientImpl.toFuture(this.retrofitImpl.getNumberOfFollowers(date));
    }

    static <T> CompletableFuture<T> toFuture(Call<T> callToWrap) {
        CallbackAdaptor completableFuture = new CallbackAdaptor();
        callToWrap.enqueue(completableFuture);
        return completableFuture;
    }

    private static CompletableFuture<BotApiResponse> toBotApiResponseFuture(Call<BotApiResponseBody> callToWrap) {
        BotApiCallbackAdaptor completableFuture = new BotApiCallbackAdaptor();
        callToWrap.enqueue((Callback)completableFuture);
        return completableFuture;
    }

    static CompletableFuture<BotApiResponse> toBotApiFuture(Call<Void> callToWrap) {
        VoidToBotApiCallbackAdaptor completableFuture = new VoidToBotApiCallbackAdaptor();
        callToWrap.enqueue((Callback)completableFuture);
        return completableFuture;
    }

    public LineMessagingClientImpl(LineMessagingService retrofitImpl, LineBlobClient blobDelegationTarget) {
        this.retrofitImpl = retrofitImpl;
        this.blobDelegationTarget = blobDelegationTarget;
    }

    static class BotApiCallbackAdaptor
    extends CompletableFuture<BotApiResponse>
    implements Callback<BotApiResponseBody> {
        BotApiCallbackAdaptor() {
        }

        public void onResponse(Call<BotApiResponseBody> call, Response<BotApiResponseBody> response) {
            if (response.isSuccessful()) {
                String requestId = response.headers().get("x-line-request-id");
                this.complete(((BotApiResponseBody)response.body()).withRequestId(requestId));
            } else {
                this.completeExceptionally(EXCEPTION_CONVERTER.apply(response));
            }
        }

        public void onFailure(Call<BotApiResponseBody> call, Throwable t) {
            this.completeExceptionally(new GeneralLineMessagingException(t.getMessage(), null, t));
        }
    }

    static class VoidToBotApiCallbackAdaptor
    extends CompletableFuture<BotApiResponse>
    implements Callback<Void> {
        VoidToBotApiCallbackAdaptor() {
        }

        public void onResponse(Call<Void> call, Response<Void> response) {
            if (response.isSuccessful()) {
                String requestId = response.headers().get("x-line-request-id");
                this.complete(BOT_API_SUCCESS_RESPONSE_BODY.withRequestId(requestId));
            } else {
                this.completeExceptionally(EXCEPTION_CONVERTER.apply(response));
            }
        }

        public void onFailure(Call<Void> call, Throwable t) {
            this.completeExceptionally(new GeneralLineMessagingException(t.getMessage(), null, t));
        }
    }

    static class CallbackAdaptor<T>
    extends CompletableFuture<T>
    implements Callback<T> {
        CallbackAdaptor() {
        }

        public void onResponse(Call<T> call, Response<T> response) {
            if (response.isSuccessful()) {
                this.complete(response.body());
            } else {
                this.completeExceptionally(EXCEPTION_CONVERTER.apply(response));
            }
        }

        public void onFailure(Call<T> call, Throwable t) {
            this.completeExceptionally(new GeneralLineMessagingException(t.getMessage(), null, t));
        }
    }
}

