/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.bot.client;

import com.linecorp.bot.client.BotApiResponseBody;
import com.linecorp.bot.model.Broadcast;
import com.linecorp.bot.model.Multicast;
import com.linecorp.bot.model.PushMessage;
import com.linecorp.bot.model.ReplyMessage;
import com.linecorp.bot.model.profile.MembersIdsResponse;
import com.linecorp.bot.model.profile.UserProfileResponse;
import com.linecorp.bot.model.response.GetNumberOfFollowersResponse;
import com.linecorp.bot.model.response.GetNumberOfMessageDeliveriesResponse;
import com.linecorp.bot.model.response.IssueLinkTokenResponse;
import com.linecorp.bot.model.response.MessageQuotaResponse;
import com.linecorp.bot.model.response.NumberOfMessagesResponse;
import com.linecorp.bot.model.response.QuotaConsumptionResponse;
import com.linecorp.bot.model.response.demographics.GetFriendsDemographicsResponse;
import com.linecorp.bot.model.richmenu.RichMenu;
import com.linecorp.bot.model.richmenu.RichMenuBulkLinkRequest;
import com.linecorp.bot.model.richmenu.RichMenuBulkUnlinkRequest;
import com.linecorp.bot.model.richmenu.RichMenuIdResponse;
import com.linecorp.bot.model.richmenu.RichMenuListResponse;
import com.linecorp.bot.model.richmenu.RichMenuResponse;
import retrofit2.Call;
import retrofit2.http.Body;
import retrofit2.http.DELETE;
import retrofit2.http.GET;
import retrofit2.http.POST;
import retrofit2.http.Path;
import retrofit2.http.Query;

interface LineMessagingService {
    @POST(value="v2/bot/message/reply")
    public Call<BotApiResponseBody> replyMessage(@Body ReplyMessage var1);

    @POST(value="v2/bot/message/push")
    public Call<BotApiResponseBody> pushMessage(@Body PushMessage var1);

    @POST(value="v2/bot/message/multicast")
    public Call<BotApiResponseBody> multicast(@Body Multicast var1);

    @POST(value="v2/bot/message/broadcast")
    public Call<BotApiResponseBody> broadcast(@Body Broadcast var1);

    @GET(value="v2/bot/message/quota")
    public Call<MessageQuotaResponse> getMessageQuota();

    @GET(value="v2/bot/message/quota/consumption")
    public Call<QuotaConsumptionResponse> getMessageQuotaConsumption();

    @GET(value="v2/bot/message/delivery/reply")
    public Call<NumberOfMessagesResponse> getNumberOfSentReplyMessages(@Query(value="date") String var1);

    @GET(value="v2/bot/message/delivery/push")
    public Call<NumberOfMessagesResponse> getNumberOfSentPushMessages(@Query(value="date") String var1);

    @GET(value="v2/bot/message/delivery/multicast")
    public Call<NumberOfMessagesResponse> getNumberOfSentMulticastMessages(@Query(value="date") String var1);

    @GET(value="v2/bot/message/delivery/broadcast")
    public Call<NumberOfMessagesResponse> getNumberOfSentBroadcastMessages(@Query(value="date") String var1);

    @GET(value="v2/bot/profile/{userId}")
    public Call<UserProfileResponse> getProfile(@Path(value="userId") String var1);

    @GET(value="v2/bot/{sourceType}/{senderId}/member/{userId}")
    public Call<UserProfileResponse> getMemberProfile(@Path(value="sourceType") String var1, @Path(value="senderId") String var2, @Path(value="userId") String var3);

    @GET(value="v2/bot/{sourceType}/{senderId}/members/ids")
    public Call<MembersIdsResponse> getMembersIds(@Path(value="sourceType") String var1, @Path(value="senderId") String var2, @Query(value="start") String var3);

    @POST(value="v2/bot/group/{groupId}/leave")
    public Call<BotApiResponseBody> leaveGroup(@Path(value="groupId") String var1);

    @POST(value="v2/bot/room/{roomId}/leave")
    public Call<BotApiResponseBody> leaveRoom(@Path(value="roomId") String var1);

    @GET(value="v2/bot/richmenu/{richMenuId}")
    public Call<RichMenuResponse> getRichMenu(@Path(value="richMenuId") String var1);

    @POST(value="v2/bot/richmenu")
    public Call<RichMenuIdResponse> createRichMenu(@Body RichMenu var1);

    @DELETE(value="v2/bot/richmenu/{richMenuId}")
    public Call<Void> deleteRichMenu(@Path(value="richMenuId") String var1);

    @GET(value="v2/bot/user/{userId}/richmenu")
    public Call<RichMenuIdResponse> getRichMenuIdOfUser(@Path(value="userId") String var1);

    @POST(value="v2/bot/user/{userId}/richmenu/{richMenuId}")
    public Call<Void> linkRichMenuToUser(@Path(value="userId") String var1, @Path(value="richMenuId") String var2);

    @POST(value="v2/bot/richmenu/bulk/link")
    public Call<Void> linkRichMenuToUsers(@Body RichMenuBulkLinkRequest var1);

    @DELETE(value="v2/bot/user/{userId}/richmenu")
    public Call<Void> unlinkRichMenuIdFromUser(@Path(value="userId") String var1);

    @POST(value="v2/bot/richmenu/bulk/unlink")
    public Call<Void> unlinkRichMenuIdFromUsers(@Body RichMenuBulkUnlinkRequest var1);

    @GET(value="v2/bot/richmenu/list")
    public Call<RichMenuListResponse> getRichMenuList();

    @POST(value="/v2/bot/user/all/richmenu/{richMenuId}")
    public Call<Void> setDefaultRichMenu(@Path(value="richMenuId") String var1);

    @GET(value="/v2/bot/user/all/richmenu")
    public Call<RichMenuIdResponse> getDefaultRichMenuId();

    @DELETE(value="/v2/bot/user/all/richmenu")
    public Call<Void> cancelDefaultRichMenu();

    @POST(value="v2/bot/user/{userId}/linkToken")
    public Call<IssueLinkTokenResponse> issueLinkToken(@Path(value="userId") String var1);

    @GET(value="v2/bot/insight/demographic")
    public Call<GetFriendsDemographicsResponse> getFriendsDemographics();

    @GET(value="v2/bot/insight/message/delivery")
    public Call<GetNumberOfMessageDeliveriesResponse> getNumberOfMessageDeliveries(@Query(value="date") String var1);

    @GET(value="v2/bot/insight/followers")
    public Call<GetNumberOfFollowersResponse> getNumberOfFollowers(@Query(value="date") String var1);
}

