/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.bot.client;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import com.fasterxml.jackson.module.paramnames.ParameterNamesModule;
import com.linecorp.bot.client.LineClientConstants;
import com.linecorp.bot.client.LineOAuthClient;
import com.linecorp.bot.client.LineOAuthClientImpl;
import com.linecorp.bot.client.LineOAuthService;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import lombok.NonNull;
import okhttp3.Interceptor;
import okhttp3.OkHttpClient;
import okhttp3.logging.HttpLoggingInterceptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import retrofit2.Converter;
import retrofit2.Retrofit;
import retrofit2.converter.jackson.JacksonConverterFactory;

public class LineOAuthClientBuilder {
    private URI apiEndPoint = LineClientConstants.DEFAULT_API_END_POINT;
    private long connectTimeout = 10000L;
    private long readTimeout = 10000L;
    private long writeTimeout = 10000L;
    private Retrofit.Builder retrofitBuilder;
    private OkHttpClient.Builder okHttpClientBuilder;
    private List<Interceptor> additionalInterceptors = new ArrayList<Interceptor>();

    LineOAuthClientBuilder() {
    }

    @Deprecated
    public LineOAuthClientBuilder apiEndPoint(String apiEndPoint) {
        return this.apiEndPoint(URI.create(apiEndPoint));
    }

    public LineOAuthClientBuilder apiEndPoint(URI apiEndPoint) {
        this.apiEndPoint = Objects.requireNonNull(apiEndPoint, "apiEndPoint");
        return this;
    }

    public LineOAuthClientBuilder okHttpClientBuilder(@NonNull OkHttpClient.Builder okHttpClientBuilder) {
        if (okHttpClientBuilder == null) {
            throw new NullPointerException("okHttpClientBuilder is marked non-null but is null");
        }
        this.okHttpClientBuilder = okHttpClientBuilder;
        return this;
    }

    private LineOAuthService buildRetrofit() {
        if (this.okHttpClientBuilder == null) {
            this.okHttpClientBuilder = new OkHttpClient.Builder();
        }
        if (this.additionalInterceptors != null) {
            this.additionalInterceptors.forEach(arg_0 -> ((OkHttpClient.Builder)this.okHttpClientBuilder).addInterceptor(arg_0));
        }
        this.okHttpClientBuilder.addInterceptor(LineOAuthClientBuilder.buildLoggingInterceptor());
        this.okHttpClientBuilder.connectTimeout(this.connectTimeout, TimeUnit.MILLISECONDS).readTimeout(this.readTimeout, TimeUnit.MILLISECONDS).writeTimeout(this.writeTimeout, TimeUnit.MILLISECONDS);
        OkHttpClient okHttpClient = this.okHttpClientBuilder.build();
        if (this.retrofitBuilder == null) {
            this.retrofitBuilder = LineOAuthClientBuilder.createDefaultRetrofitBuilder();
        }
        this.retrofitBuilder.client(okHttpClient);
        this.retrofitBuilder.baseUrl(this.apiEndPoint.toString());
        Retrofit retrofit = this.retrofitBuilder.build();
        return (LineOAuthService)retrofit.create(LineOAuthService.class);
    }

    private static Interceptor buildLoggingInterceptor() {
        Logger slf4jLogger = LoggerFactory.getLogger((String)"com.linecorp.bot.client.wire");
        return new HttpLoggingInterceptor(arg_0 -> ((Logger)slf4jLogger).info(arg_0)).setLevel(HttpLoggingInterceptor.Level.BODY);
    }

    private static Retrofit.Builder createDefaultRetrofitBuilder() {
        ObjectMapper objectMapper = new ObjectMapper().configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false).registerModule((Module)new ParameterNamesModule()).registerModule((Module)new JavaTimeModule()).configure(DeserializationFeature.READ_DATE_TIMESTAMPS_AS_NANOSECONDS, false);
        return new Retrofit.Builder().addConverterFactory((Converter.Factory)JacksonConverterFactory.create((ObjectMapper)objectMapper));
    }

    public LineOAuthClient build() {
        return new LineOAuthClientImpl(this.buildRetrofit());
    }

    public String toString() {
        return "LineOAuthClientBuilder(apiEndPoint=" + this.apiEndPoint + ", connectTimeout=" + this.connectTimeout + ", readTimeout=" + this.readTimeout + ", writeTimeout=" + this.writeTimeout + ", retrofitBuilder=" + this.retrofitBuilder + ", okHttpClientBuilder=" + this.okHttpClientBuilder + ", additionalInterceptors=" + this.additionalInterceptors + ")";
    }

    public LineOAuthClientBuilder connectTimeout(long connectTimeout) {
        this.connectTimeout = connectTimeout;
        return this;
    }

    public LineOAuthClientBuilder readTimeout(long readTimeout) {
        this.readTimeout = readTimeout;
        return this;
    }

    public LineOAuthClientBuilder writeTimeout(long writeTimeout) {
        this.writeTimeout = writeTimeout;
        return this;
    }

    public LineOAuthClientBuilder retrofitBuilder(Retrofit.Builder retrofitBuilder) {
        this.retrofitBuilder = retrofitBuilder;
        return this;
    }

    public LineOAuthClientBuilder additionalInterceptors(List<Interceptor> additionalInterceptors) {
        this.additionalInterceptors = additionalInterceptors;
        return this;
    }
}

