/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.bot.client;

import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.Map;

public class MessageContentResponse
implements AutoCloseable {
    final long length;
    final InputStream stream;
    final String mimeType;
    final Map<String, List<String>> allHeaders;

    @Override
    public void close() throws IOException {
        this.stream.close();
    }

    MessageContentResponse(long length, InputStream stream, String mimeType, Map<String, List<String>> allHeaders) {
        this.length = length;
        this.stream = stream;
        this.mimeType = mimeType;
        this.allHeaders = allHeaders;
    }

    public static MessageContentResponseBuilder builder() {
        return new MessageContentResponseBuilder();
    }

    public long getLength() {
        return this.length;
    }

    public InputStream getStream() {
        return this.stream;
    }

    public String getMimeType() {
        return this.mimeType;
    }

    public Map<String, List<String>> getAllHeaders() {
        return this.allHeaders;
    }

    public String toString() {
        return "MessageContentResponse(length=" + this.getLength() + ", stream=" + this.getStream() + ", mimeType=" + this.getMimeType() + ", allHeaders=" + this.getAllHeaders() + ")";
    }

    public static class MessageContentResponseBuilder {
        private long length;
        private InputStream stream;
        private String mimeType;
        private Map<String, List<String>> allHeaders;

        MessageContentResponseBuilder() {
        }

        public MessageContentResponseBuilder length(long length) {
            this.length = length;
            return this;
        }

        public MessageContentResponseBuilder stream(InputStream stream) {
            this.stream = stream;
            return this;
        }

        public MessageContentResponseBuilder mimeType(String mimeType) {
            this.mimeType = mimeType;
            return this;
        }

        public MessageContentResponseBuilder allHeaders(Map<String, List<String>> allHeaders) {
            this.allHeaders = allHeaders;
            return this;
        }

        public MessageContentResponse build() {
            return new MessageContentResponse(this.length, this.stream, this.mimeType, this.allHeaders);
        }

        public String toString() {
            return "MessageContentResponse.MessageContentResponseBuilder(length=" + this.length + ", stream=" + this.stream + ", mimeType=" + this.mimeType + ", allHeaders=" + this.allHeaders + ")";
        }
    }
}

