/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.bot.client;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.linecorp.bot.client.ChannelTokenSupplier;
import com.linecorp.bot.client.FixedChannelTokenSupplier;
import com.linecorp.bot.client.HeaderInterceptor;
import com.linecorp.bot.client.LineBlobClient;
import com.linecorp.bot.client.LineBlobClientImpl;
import com.linecorp.bot.client.LineBlobService;
import com.linecorp.bot.client.LineClientConstants;
import com.linecorp.bot.model.objectmapper.ModelObjectMapper;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import lombok.Generated;
import lombok.NonNull;
import okhttp3.Interceptor;
import okhttp3.OkHttpClient;
import okhttp3.logging.HttpLoggingInterceptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import retrofit2.Converter;
import retrofit2.Retrofit;
import retrofit2.converter.jackson.JacksonConverterFactory;

public class LineBlobClientBuilder {
    private static final ObjectMapper objectMapper = ModelObjectMapper.createNewObjectMapper();
    private URI apiEndPoint = LineClientConstants.DEFAULT_BLOB_END_POINT;
    private long connectTimeout = 10000L;
    private long readTimeout = 10000L;
    private long writeTimeout = 10000L;
    private ChannelTokenSupplier channelTokenSupplier;
    private Retrofit.Builder retrofitBuilder;
    private boolean addAuthenticationHeader = true;
    private OkHttpClient.Builder okHttpClientBuilder;
    private List<Interceptor> additionalInterceptors = new ArrayList<Interceptor>();

    LineBlobClientBuilder() {
    }

    public LineBlobClientBuilder apiEndPoint(URI apiEndPoint) {
        this.apiEndPoint = Objects.requireNonNull(apiEndPoint, "apiEndPoint");
        return this;
    }

    public LineBlobClientBuilder channelToken(String channelToken) {
        this.channelTokenSupplier(FixedChannelTokenSupplier.of(channelToken));
        return this;
    }

    public LineBlobClientBuilder okHttpClientBuilder(@NonNull OkHttpClient.Builder okHttpClientBuilder, boolean addAuthenticationHeader) {
        if (okHttpClientBuilder == null) {
            throw new NullPointerException("okHttpClientBuilder is marked non-null but is null");
        }
        this.okHttpClientBuilder = okHttpClientBuilder;
        this.addAuthenticationHeader = addAuthenticationHeader;
        return this;
    }

    <T> T buildRetrofitIface(URI apiEndPoint, Class<T> retrofitIFace) {
        if (this.okHttpClientBuilder == null) {
            this.okHttpClientBuilder = new OkHttpClient.Builder();
        }
        if (this.addAuthenticationHeader) {
            this.okHttpClientBuilder.addInterceptor((Interceptor)LineBlobClientBuilder.buildAuthenticationInterceptor(this.channelTokenSupplier));
        }
        if (this.additionalInterceptors != null) {
            this.additionalInterceptors.forEach(arg_0 -> ((OkHttpClient.Builder)this.okHttpClientBuilder).addInterceptor(arg_0));
        }
        this.okHttpClientBuilder.addInterceptor(LineBlobClientBuilder.buildLoggingInterceptor());
        this.okHttpClientBuilder.connectTimeout(this.connectTimeout, TimeUnit.MILLISECONDS).readTimeout(this.readTimeout, TimeUnit.MILLISECONDS).writeTimeout(this.writeTimeout, TimeUnit.MILLISECONDS);
        OkHttpClient okHttpClient = this.okHttpClientBuilder.build();
        if (this.retrofitBuilder == null) {
            this.retrofitBuilder = LineBlobClientBuilder.createDefaultRetrofitBuilder();
        }
        this.retrofitBuilder.client(okHttpClient);
        this.retrofitBuilder.baseUrl(apiEndPoint.toString());
        Retrofit retrofit = this.retrofitBuilder.build();
        return (T)retrofit.create(retrofitIFace);
    }

    static HeaderInterceptor buildAuthenticationInterceptor(ChannelTokenSupplier channelTokenSupplier) {
        Objects.requireNonNull(channelTokenSupplier, "channelTokenSupplier");
        return HeaderInterceptor.forChannelTokenSupplier(channelTokenSupplier);
    }

    static Interceptor buildLoggingInterceptor() {
        Logger slf4jLogger = LoggerFactory.getLogger((String)"com.linecorp.bot.client.wire");
        return new HttpLoggingInterceptor(arg_0 -> ((Logger)slf4jLogger).info(arg_0)).setLevel(HttpLoggingInterceptor.Level.BODY);
    }

    static Retrofit.Builder createDefaultRetrofitBuilder() {
        return new Retrofit.Builder().addConverterFactory((Converter.Factory)JacksonConverterFactory.create((ObjectMapper)objectMapper));
    }

    public LineBlobClient build() {
        return new LineBlobClientImpl(this.buildRetrofitIface(this.apiEndPoint, LineBlobService.class));
    }

    public LineBlobClient buildBlobClient() {
        return new LineBlobClientImpl(this.buildRetrofitIface(this.apiEndPoint, LineBlobService.class));
    }

    @Generated
    public String toString() {
        return "LineBlobClientBuilder(apiEndPoint=" + this.apiEndPoint + ", connectTimeout=" + this.connectTimeout + ", readTimeout=" + this.readTimeout + ", writeTimeout=" + this.writeTimeout + ", channelTokenSupplier=" + this.channelTokenSupplier + ", retrofitBuilder=" + this.retrofitBuilder + ", addAuthenticationHeader=" + this.addAuthenticationHeader + ", okHttpClientBuilder=" + this.okHttpClientBuilder + ", additionalInterceptors=" + this.additionalInterceptors + ")";
    }

    @Generated
    public LineBlobClientBuilder connectTimeout(long connectTimeout) {
        this.connectTimeout = connectTimeout;
        return this;
    }

    @Generated
    public LineBlobClientBuilder readTimeout(long readTimeout) {
        this.readTimeout = readTimeout;
        return this;
    }

    @Generated
    public LineBlobClientBuilder writeTimeout(long writeTimeout) {
        this.writeTimeout = writeTimeout;
        return this;
    }

    @Generated
    public LineBlobClientBuilder channelTokenSupplier(ChannelTokenSupplier channelTokenSupplier) {
        this.channelTokenSupplier = channelTokenSupplier;
        return this;
    }

    @Generated
    public LineBlobClientBuilder retrofitBuilder(Retrofit.Builder retrofitBuilder) {
        this.retrofitBuilder = retrofitBuilder;
        return this;
    }

    @Generated
    public LineBlobClientBuilder addAuthenticationHeader(boolean addAuthenticationHeader) {
        this.addAuthenticationHeader = addAuthenticationHeader;
        return this;
    }

    @Generated
    public LineBlobClientBuilder additionalInterceptors(List<Interceptor> additionalInterceptors) {
        this.additionalInterceptors = additionalInterceptors;
        return this;
    }
}

