/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.bot.client;

import com.linecorp.bot.client.ChannelTokenSupplier;
import com.linecorp.bot.client.FixedChannelTokenSupplier;
import com.linecorp.bot.client.LineMessagingClientBuilder;
import com.linecorp.bot.model.Broadcast;
import com.linecorp.bot.model.Multicast;
import com.linecorp.bot.model.Narrowcast;
import com.linecorp.bot.model.PushMessage;
import com.linecorp.bot.model.ReplyMessage;
import com.linecorp.bot.model.group.GroupMemberCountResponse;
import com.linecorp.bot.model.group.GroupSummaryResponse;
import com.linecorp.bot.model.profile.MembersIdsResponse;
import com.linecorp.bot.model.profile.UserProfileResponse;
import com.linecorp.bot.model.request.GetFollowersRequest;
import com.linecorp.bot.model.request.SetWebhookEndpointRequest;
import com.linecorp.bot.model.request.TestWebhookEndpointRequest;
import com.linecorp.bot.model.response.BotApiResponse;
import com.linecorp.bot.model.response.BotInfoResponse;
import com.linecorp.bot.model.response.GetAggregationUnitNameListResponse;
import com.linecorp.bot.model.response.GetAggregationUnitUsageResponse;
import com.linecorp.bot.model.response.GetFollowersResponse;
import com.linecorp.bot.model.response.GetMessageEventResponse;
import com.linecorp.bot.model.response.GetNumberOfFollowersResponse;
import com.linecorp.bot.model.response.GetNumberOfMessageDeliveriesResponse;
import com.linecorp.bot.model.response.GetStatisticsPerUnitResponse;
import com.linecorp.bot.model.response.GetWebhookEndpointResponse;
import com.linecorp.bot.model.response.IssueLinkTokenResponse;
import com.linecorp.bot.model.response.MessageQuotaResponse;
import com.linecorp.bot.model.response.NarrowcastProgressResponse;
import com.linecorp.bot.model.response.NumberOfMessagesResponse;
import com.linecorp.bot.model.response.QuotaConsumptionResponse;
import com.linecorp.bot.model.response.SetWebhookEndpointResponse;
import com.linecorp.bot.model.response.TestWebhookEndpointResponse;
import com.linecorp.bot.model.response.demographics.GetFriendsDemographicsResponse;
import com.linecorp.bot.model.richmenu.RichMenu;
import com.linecorp.bot.model.richmenu.RichMenuIdResponse;
import com.linecorp.bot.model.richmenu.RichMenuListResponse;
import com.linecorp.bot.model.richmenu.RichMenuResponse;
import com.linecorp.bot.model.richmenualias.CreateRichMenuAliasRequest;
import com.linecorp.bot.model.richmenualias.RichMenuAliasListResponse;
import com.linecorp.bot.model.richmenualias.RichMenuAliasResponse;
import com.linecorp.bot.model.richmenualias.UpdateRichMenuAliasRequest;
import com.linecorp.bot.model.room.RoomMemberCountResponse;
import java.util.List;
import java.util.concurrent.CompletableFuture;

public interface LineMessagingClient {
    public CompletableFuture<BotApiResponse> replyMessage(ReplyMessage var1);

    public CompletableFuture<BotApiResponse> pushMessage(PushMessage var1);

    public CompletableFuture<BotApiResponse> multicast(Multicast var1);

    public CompletableFuture<BotApiResponse> broadcast(Broadcast var1);

    public CompletableFuture<BotApiResponse> narrowcast(Narrowcast var1);

    public CompletableFuture<NarrowcastProgressResponse> getNarrowcastProgress(String var1);

    public CompletableFuture<MessageQuotaResponse> getMessageQuota();

    public CompletableFuture<QuotaConsumptionResponse> getMessageQuotaConsumption();

    public CompletableFuture<NumberOfMessagesResponse> getNumberOfSentReplyMessages(String var1);

    public CompletableFuture<NumberOfMessagesResponse> getNumberOfSentPushMessages(String var1);

    public CompletableFuture<NumberOfMessagesResponse> getNumberOfSentMulticastMessages(String var1);

    public CompletableFuture<NumberOfMessagesResponse> getNumberOfSentBroadcastMessages(String var1);

    public CompletableFuture<UserProfileResponse> getProfile(String var1);

    public CompletableFuture<UserProfileResponse> getGroupMemberProfile(String var1, String var2);

    public CompletableFuture<UserProfileResponse> getRoomMemberProfile(String var1, String var2);

    public CompletableFuture<MembersIdsResponse> getGroupMembersIds(String var1, String var2);

    public CompletableFuture<MembersIdsResponse> getRoomMembersIds(String var1, String var2);

    public CompletableFuture<BotApiResponse> leaveGroup(String var1);

    public CompletableFuture<BotApiResponse> leaveRoom(String var1);

    public CompletableFuture<GroupSummaryResponse> getGroupSummary(String var1);

    public CompletableFuture<GroupMemberCountResponse> getGroupMemberCount(String var1);

    public CompletableFuture<RoomMemberCountResponse> getRoomMemberCount(String var1);

    public CompletableFuture<RichMenuResponse> getRichMenu(String var1);

    public CompletableFuture<RichMenuIdResponse> createRichMenu(RichMenu var1);

    public CompletableFuture<BotApiResponse> deleteRichMenu(String var1);

    public CompletableFuture<RichMenuIdResponse> getRichMenuIdOfUser(String var1);

    public CompletableFuture<BotApiResponse> linkRichMenuIdToUser(String var1, String var2);

    public CompletableFuture<BotApiResponse> linkRichMenuIdToUsers(List<String> var1, String var2);

    public CompletableFuture<BotApiResponse> unlinkRichMenuIdFromUser(String var1);

    public CompletableFuture<BotApiResponse> unlinkRichMenuIdFromUsers(List<String> var1);

    public CompletableFuture<RichMenuListResponse> getRichMenuList();

    public CompletableFuture<BotApiResponse> setDefaultRichMenu(String var1);

    public CompletableFuture<RichMenuIdResponse> getDefaultRichMenuId();

    public CompletableFuture<BotApiResponse> cancelDefaultRichMenu();

    public CompletableFuture<BotApiResponse> createRichMenuAlias(CreateRichMenuAliasRequest var1);

    public CompletableFuture<BotApiResponse> updateRichMenuAlias(String var1, UpdateRichMenuAliasRequest var2);

    public CompletableFuture<RichMenuAliasResponse> getRichMenuAlias(String var1);

    public CompletableFuture<RichMenuAliasListResponse> getRichMenuAliasList();

    public CompletableFuture<BotApiResponse> deleteRichMenuAlias(String var1);

    public CompletableFuture<IssueLinkTokenResponse> issueLinkToken(String var1);

    public CompletableFuture<GetNumberOfMessageDeliveriesResponse> getNumberOfMessageDeliveries(String var1);

    public CompletableFuture<GetNumberOfFollowersResponse> getNumberOfFollowers(String var1);

    public CompletableFuture<GetFollowersResponse> getFollowers(GetFollowersRequest var1);

    public CompletableFuture<GetMessageEventResponse> getMessageEvent(String var1);

    public CompletableFuture<GetFriendsDemographicsResponse> getFriendsDemographics();

    public CompletableFuture<BotInfoResponse> getBotInfo();

    public CompletableFuture<GetWebhookEndpointResponse> getWebhookEndpoint();

    public CompletableFuture<SetWebhookEndpointResponse> setWebhookEndpoint(SetWebhookEndpointRequest var1);

    public CompletableFuture<TestWebhookEndpointResponse> testWebhookEndpoint(TestWebhookEndpointRequest var1);

    public CompletableFuture<GetStatisticsPerUnitResponse> getStatisticsPerUnit(String var1, String var2, String var3);

    public CompletableFuture<GetAggregationUnitUsageResponse> getAggregationUnitUsage();

    public CompletableFuture<GetAggregationUnitNameListResponse> getAggregationUnitNameList(String var1, String var2);

    public static LineMessagingClientBuilder builder(String channelToken) {
        return LineMessagingClient.builder(FixedChannelTokenSupplier.of(channelToken));
    }

    public static LineMessagingClientBuilder builder(ChannelTokenSupplier channelTokenSupplier) {
        return new LineMessagingClientBuilder().channelTokenSupplier(channelTokenSupplier);
    }
}

