/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.bot.client;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.linecorp.bot.client.LineOAuthClient;
import com.linecorp.bot.client.LineOAuthService;
import com.linecorp.bot.model.oauth.ChannelAccessTokenException;
import com.linecorp.bot.model.oauth.ChannelAccessTokenKeyIdsResponse;
import com.linecorp.bot.model.oauth.IssueChannelAccessTokenRequest;
import com.linecorp.bot.model.oauth.IssueChannelAccessTokenResponse;
import com.linecorp.bot.model.objectmapper.ModelObjectMapper;
import java.io.IOException;
import java.util.concurrent.CompletableFuture;
import lombok.Generated;
import retrofit2.Call;
import retrofit2.Callback;
import retrofit2.Response;

class LineOAuthClientImpl
implements LineOAuthClient {
    private static final ObjectMapper objectMapper = ModelObjectMapper.createNewObjectMapper();
    private final LineOAuthService service;

    @Override
    public CompletableFuture<ChannelAccessTokenKeyIdsResponse> getsAllValidChannelAccessTokenKeyIdsByJWT(String jwt) {
        return LineOAuthClientImpl.toFuture(this.service.getsAllValidChannelAccessTokenKeyIds("urn:ietf:params:oauth:client-assertion-type:jwt-bearer", jwt));
    }

    @Override
    public CompletableFuture<IssueChannelAccessTokenResponse> issueChannelTokenByJWT(String jwt) {
        return LineOAuthClientImpl.toFuture(this.service.issueChannelTokenByJWT("client_credentials", "urn:ietf:params:oauth:client-assertion-type:jwt-bearer", jwt));
    }

    @Override
    public CompletableFuture<Void> revokeChannelTokenByJWT(String clientId, String clientSecret, String accessToken) {
        return LineOAuthClientImpl.toFuture(this.service.revokeChannelTokenByJWT(clientId, clientSecret, accessToken));
    }

    @Override
    public CompletableFuture<IssueChannelAccessTokenResponse> issueChannelToken(IssueChannelAccessTokenRequest req) {
        return LineOAuthClientImpl.toFuture(this.service.issueChannelToken(req.getGrantType(), req.getClientId(), req.getClientSecret()));
    }

    @Override
    public CompletableFuture<Void> revokeChannelToken(String accessToken) {
        return LineOAuthClientImpl.toFuture(this.service.revokeChannelToken(accessToken));
    }

    private static <T> CompletableFuture<T> toFuture(Call<T> call) {
        CallbackCompletableFuture future = new CallbackCompletableFuture();
        call.enqueue(future);
        return future;
    }

    @Generated
    public LineOAuthClientImpl(LineOAuthService service) {
        this.service = service;
    }

    static class CallbackCompletableFuture<T>
    extends CompletableFuture<T>
    implements Callback<T> {
        CallbackCompletableFuture() {
        }

        public void onResponse(Call<T> call, Response<T> response) {
            if (response.isSuccessful()) {
                this.complete(response.body());
                return;
            }
            if (response.code() == 400) {
                try {
                    this.completeExceptionally((Throwable)objectMapper.readValue(response.errorBody().string(), ChannelAccessTokenException.class));
                    return;
                }
                catch (IOException e) {
                    this.completeExceptionally(e);
                }
            }
            this.completeExceptionally((Throwable)new ChannelAccessTokenException(response.message()));
        }

        public void onFailure(Call<T> call, Throwable t) {
            this.completeExceptionally((Throwable)new ChannelAccessTokenException(t.getMessage(), t));
        }
    }
}

