/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.bot.client;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.linecorp.bot.client.LineMessagingClientImpl;
import com.linecorp.bot.client.ManageAudienceBlobClient;
import com.linecorp.bot.client.ManageAudienceBlobService;
import com.linecorp.bot.model.manageaudience.ManageAudienceException;
import com.linecorp.bot.model.manageaudience.response.CreateAudienceForUploadingResponse;
import com.linecorp.bot.model.objectmapper.ModelObjectMapper;
import com.linecorp.bot.model.response.BotApiResponse;
import java.io.File;
import java.io.IOException;
import java.util.concurrent.CompletableFuture;
import okhttp3.MediaType;
import okhttp3.MultipartBody;
import okhttp3.RequestBody;
import retrofit2.Call;
import retrofit2.Callback;
import retrofit2.Response;

public class ManageAudienceBlobClientImpl
implements ManageAudienceBlobClient {
    private static final ObjectMapper objectMapper = ModelObjectMapper.createNewObjectMapper();
    private final ManageAudienceBlobService retrofitImpl;

    public ManageAudienceBlobClientImpl(ManageAudienceBlobService retrofitImpl) {
        this.retrofitImpl = retrofitImpl;
    }

    @Override
    public CompletableFuture<CreateAudienceForUploadingResponse> createAudienceForUploadingUserIds(String description, boolean isIfaAudience, String uploadDescription, File file) {
        MultipartBody parts = new MultipartBody.Builder().addFormDataPart("description", description).addFormDataPart("isIfaAudience", String.valueOf(isIfaAudience)).addFormDataPart("uploadDescription", uploadDescription).addFormDataPart("file", file.getName(), RequestBody.create((MediaType)MediaType.get((String)"text/plain"), (File)file)).build();
        return ManageAudienceBlobClientImpl.toFuture(this.retrofitImpl.createAudienceForUploadingUserIds(parts));
    }

    @Override
    public CompletableFuture<BotApiResponse> addUserIdsToAudience(long audienceGroupId, String uploadDescription, File file) {
        MultipartBody parts = new MultipartBody.Builder().addFormDataPart("audienceGroupId", String.valueOf(audienceGroupId)).addFormDataPart("uploadDescription", uploadDescription).addFormDataPart("file", file.getName(), RequestBody.create((MediaType)MediaType.get((String)"text/plain"), (File)file)).build();
        return LineMessagingClientImpl.toBotApiFuture(this.retrofitImpl.addUserIdsToAudience(parts));
    }

    private static <T> CompletableFuture<T> toFuture(Call<T> call) {
        CallbackCompletableFuture future = new CallbackCompletableFuture();
        call.enqueue(future);
        return future;
    }

    private static class CallbackCompletableFuture<T>
    extends CompletableFuture<T>
    implements Callback<T> {
        private CallbackCompletableFuture() {
        }

        public void onResponse(Call<T> call, Response<T> response) {
            if (response.isSuccessful()) {
                this.complete(response.body());
                return;
            }
            if (response.code() == 400) {
                try {
                    this.completeExceptionally((Throwable)objectMapper.readValue(response.errorBody().string(), ManageAudienceException.class));
                    return;
                }
                catch (IOException e) {
                    this.completeExceptionally(e);
                }
            }
            this.completeExceptionally((Throwable)new ManageAudienceException(response.message()));
        }

        public void onFailure(Call<T> call, Throwable t) {
            this.completeExceptionally((Throwable)new ManageAudienceException(t.getMessage(), t));
        }
    }
}

