/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.bot.client;

import com.linecorp.bot.client.BotApiResponseBody;
import com.linecorp.bot.client.ExceptionConverter;
import com.linecorp.bot.client.LineMessagingService;
import com.linecorp.bot.client.RetryableLineMessagingClient;
import com.linecorp.bot.client.exception.GeneralLineMessagingException;
import com.linecorp.bot.model.Broadcast;
import com.linecorp.bot.model.Multicast;
import com.linecorp.bot.model.Narrowcast;
import com.linecorp.bot.model.PushMessage;
import com.linecorp.bot.model.response.BotApiResponse;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import retrofit2.Call;
import retrofit2.Callback;
import retrofit2.Response;

public class RetryableLineMessagingClientImpl
implements RetryableLineMessagingClient {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(RetryableLineMessagingClientImpl.class);
    static final ExceptionConverter EXCEPTION_CONVERTER = new ExceptionConverter();
    private final LineMessagingService retrofitImpl;

    @Override
    public CompletableFuture<BotApiResponse> pushMessage(UUID retryKey, PushMessage pushMessage) {
        return RetryableLineMessagingClientImpl.toBotApiResponseFuture(this.retrofitImpl.pushMessage(retryKey.toString(), pushMessage));
    }

    @Override
    public CompletableFuture<BotApiResponse> multicast(UUID retryKey, Multicast multicast) {
        return RetryableLineMessagingClientImpl.toBotApiResponseFuture(this.retrofitImpl.multicast(retryKey.toString(), multicast));
    }

    @Override
    public CompletableFuture<BotApiResponse> broadcast(UUID retryKey, Broadcast broadcast) {
        return RetryableLineMessagingClientImpl.toBotApiResponseFuture(this.retrofitImpl.broadcast(retryKey.toString(), broadcast));
    }

    @Override
    public CompletableFuture<BotApiResponse> narrowcast(UUID retryKey, Narrowcast narrowcast) {
        return RetryableLineMessagingClientImpl.toBotApiResponseFuture(this.retrofitImpl.narrowcast(retryKey.toString(), narrowcast));
    }

    private static CompletableFuture<BotApiResponse> toBotApiResponseFuture(Call<BotApiResponseBody> callToWrap) {
        BotApiCallbackAdaptor completableFuture = new BotApiCallbackAdaptor();
        callToWrap.enqueue((Callback)completableFuture);
        return completableFuture;
    }

    @Generated
    public RetryableLineMessagingClientImpl(LineMessagingService retrofitImpl) {
        this.retrofitImpl = retrofitImpl;
    }

    static class BotApiCallbackAdaptor
    extends CompletableFuture<BotApiResponse>
    implements Callback<BotApiResponseBody> {
        BotApiCallbackAdaptor() {
        }

        public void onResponse(Call<BotApiResponseBody> call, Response<BotApiResponseBody> response) {
            if (response.isSuccessful()) {
                String requestId = response.headers().get("x-line-request-id");
                this.complete(((BotApiResponseBody)response.body()).withRequestId(requestId));
            } else {
                this.completeExceptionally(EXCEPTION_CONVERTER.apply(response));
            }
        }

        public void onFailure(Call<BotApiResponseBody> call, Throwable t) {
            this.completeExceptionally(new GeneralLineMessagingException(t.getMessage(), null, t));
        }
    }
}

