/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.bot.client.base;

import com.fasterxml.jackson.core.exc.StreamReadException;
import com.fasterxml.jackson.databind.DatabindException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.linecorp.bot.client.base.ExceptionBuilder;
import com.linecorp.bot.client.base.LineClientJsonParseException;
import com.linecorp.bot.jackson.ModelObjectMapper;
import java.io.IOException;
import java.util.Objects;
import okhttp3.Response;
import okhttp3.ResponseBody;

public abstract class AbstractExceptionBuilder<E>
implements ExceptionBuilder {
    private final ObjectMapper objectMapper = ModelObjectMapper.createNewObjectMapper();
    private final Class<E> errorBodyClass;

    public AbstractExceptionBuilder(Class<E> errorBodyClass) {
        this.errorBodyClass = errorBodyClass;
    }

    @Override
    public IOException build(Response response) throws IOException {
        try {
            E errorBody = this.parseErrorBody(response);
            return this.buildException(response, errorBody);
        }
        catch (StreamReadException | DatabindException e) {
            return new LineClientJsonParseException(response, (IOException)e);
        }
    }

    protected abstract IOException buildException(Response var1, E var2);

    protected E parseErrorBody(Response response) throws IOException, StreamReadException, DatabindException {
        ResponseBody body = Objects.requireNonNull(response.body(), "response.body");
        return (E)this.objectMapper.readValue(Objects.requireNonNull(body.byteStream()), this.errorBodyClass);
    }
}

