/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.bot.client.base;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.linecorp.bot.client.base.BotAwareJacksonConverter;
import com.linecorp.bot.client.base.ExceptionBuilder;
import com.linecorp.bot.client.base.ResultCallAdapterFactory;
import com.linecorp.bot.client.base.http.HttpAuthenticator;
import com.linecorp.bot.client.base.http.HttpChain;
import com.linecorp.bot.client.base.http.HttpInterceptor;
import com.linecorp.bot.client.base.http.HttpResponse;
import com.linecorp.bot.jackson.ModelObjectMapper;
import java.net.Proxy;
import java.net.URI;
import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import okhttp3.Dispatcher;
import okhttp3.Interceptor;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.logging.HttpLoggingInterceptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import retrofit2.CallAdapter;
import retrofit2.Retrofit;

public class ApiClientBuilder<T> {
    private final ObjectMapper objectMapper = ModelObjectMapper.createNewObjectMapper();
    private final Class<T> clientClass;
    private final ExceptionBuilder exceptionBuilder;
    private URI apiEndPoint;
    private Duration connectTimeout = Duration.ofSeconds(10L);
    private Duration readTimeout = Duration.ofSeconds(10L);
    private Duration writeTimeout = Duration.ofSeconds(10L);
    private List<Interceptor> additionalInterceptors = new ArrayList<Interceptor>();
    private Proxy proxy;
    private HttpAuthenticator proxyAuthenticator;
    private Integer maxRequests = 64;
    private Integer maxRequestsPerHost = 5;

    public ApiClientBuilder(URI apiEndPoint, Class<T> clientClass, ExceptionBuilder exceptionBuilder) {
        this.apiEndPoint = apiEndPoint;
        this.clientClass = clientClass;
        this.exceptionBuilder = exceptionBuilder;
    }

    public ApiClientBuilder<T> apiEndPoint(URI apiEndPoint) {
        this.apiEndPoint = Objects.requireNonNull(apiEndPoint, "apiEndPoint");
        return this;
    }

    public ApiClientBuilder<T> failOnUnknownProperties(Boolean failOnUnknownProperties) {
        this.objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, failOnUnknownProperties.booleanValue());
        return this;
    }

    public ApiClientBuilder<T> connectTimeout(Duration connectTimeout) {
        this.connectTimeout = connectTimeout;
        return this;
    }

    public ApiClientBuilder<T> readTimeout(Duration readTimeout) {
        this.readTimeout = readTimeout;
        return this;
    }

    public ApiClientBuilder<T> writeTimeout(Duration writeTimeout) {
        this.writeTimeout = writeTimeout;
        return this;
    }

    public ApiClientBuilder<T> addInterceptor(HttpInterceptor interceptor) {
        this.additionalInterceptors.add(chain -> {
            HttpChain httpChain = new HttpChain(chain);
            HttpResponse httpResponse = interceptor.intercept(httpChain);
            return httpResponse.toOkHttpResponse();
        });
        return this;
    }

    public ApiClientBuilder<T> maxRequests(Integer maxRequests) {
        this.maxRequests = maxRequests;
        return this;
    }

    public ApiClientBuilder<T> maxRequestsPerHost(Integer maxRequestsPerHost) {
        this.maxRequestsPerHost = maxRequestsPerHost;
        return this;
    }

    private static Interceptor buildLoggingInterceptor() {
        Logger slf4jLogger = LoggerFactory.getLogger((String)"com.linecorp.bot.client.wire");
        return new HttpLoggingInterceptor(arg_0 -> ((Logger)slf4jLogger).info(arg_0)).setLevel(HttpLoggingInterceptor.Level.BODY);
    }

    public ApiClientBuilder<T> proxy(Proxy proxy) {
        this.proxy = proxy;
        return this;
    }

    public ApiClientBuilder<T> proxyAuthenticator(HttpAuthenticator proxyAuthenticator) {
        this.proxyAuthenticator = proxyAuthenticator;
        return this;
    }

    OkHttpClient.Builder createBuilder() {
        return new OkHttpClient.Builder();
    }

    Dispatcher createDispatcher() {
        return new Dispatcher();
    }

    public T build() {
        OkHttpClient.Builder okHttpClientBuilder = this.createBuilder();
        this.additionalInterceptors.forEach(arg_0 -> ((OkHttpClient.Builder)okHttpClientBuilder).addInterceptor(arg_0));
        okHttpClientBuilder.addInterceptor(ApiClientBuilder.buildLoggingInterceptor());
        okHttpClientBuilder.connectTimeout(this.connectTimeout).readTimeout(this.readTimeout).writeTimeout(this.writeTimeout);
        Dispatcher dispatcher = this.createDispatcher();
        dispatcher.setMaxRequests(this.maxRequests.intValue());
        dispatcher.setMaxRequestsPerHost(this.maxRequestsPerHost.intValue());
        okHttpClientBuilder.dispatcher(dispatcher);
        okHttpClientBuilder.addInterceptor(chain -> {
            Request request = chain.request();
            Response response = chain.proceed(request);
            if (response.isSuccessful()) {
                return response;
            }
            throw this.exceptionBuilder.build(response);
        });
        if (this.proxy != null) {
            okHttpClientBuilder.proxy(this.proxy);
        }
        if (this.proxyAuthenticator != null) {
            okHttpClientBuilder.proxyAuthenticator((route, response) -> this.proxyAuthenticator.authenticate(new HttpResponse(response)).toOkHttpRequest());
        }
        Retrofit.Builder retrofitBuilder = new Retrofit.Builder().addConverterFactory(BotAwareJacksonConverter.create(this.objectMapper));
        retrofitBuilder.client(okHttpClientBuilder.build());
        retrofitBuilder.addCallAdapterFactory((CallAdapter.Factory)new ResultCallAdapterFactory());
        retrofitBuilder.baseUrl(this.apiEndPoint.toString());
        Retrofit retrofit = retrofitBuilder.build();
        return (T)retrofit.create(this.clientClass);
    }

    public String toString() {
        return "ApiClientBuilder{objectMapper=" + this.objectMapper + ", clientClass=" + this.clientClass + ", exceptionBuilder=" + this.exceptionBuilder + ", apiEndPoint=" + this.apiEndPoint + ", connectTimeout=" + this.connectTimeout + ", readTimeout=" + this.readTimeout + ", writeTimeout=" + this.writeTimeout + ", additionalInterceptors=" + this.additionalInterceptors + ", maxRequests=" + this.maxRequests + ", maxRequestsPerHost=" + this.maxRequestsPerHost + "}";
    }
}

