/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.bot.client.base;

import com.linecorp.bot.client.base.Result;
import java.lang.annotation.Annotation;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.concurrent.CompletableFuture;
import kotlin.NotImplementedError;
import org.jetbrains.annotations.Nullable;
import retrofit2.Call;
import retrofit2.CallAdapter;
import retrofit2.Callback;
import retrofit2.Response;
import retrofit2.Retrofit;

public class ResultCallAdapterFactory
extends CallAdapter.Factory {
    @Nullable
    public CallAdapter<?, ?> get(Type returnType, Annotation[] annotations, Retrofit retrofit) {
        if (ResultCallAdapterFactory.getRawType((Type)returnType) != CompletableFuture.class) {
            return null;
        }
        if (!(returnType instanceof ParameterizedType)) {
            throw new IllegalStateException("CompletableFuture return type must be parameterized as CompletableFuture<Foo> or CompletableFuture<? extends Foo>");
        }
        Type innerType = ResultCallAdapterFactory.getParameterUpperBound((int)0, (ParameterizedType)((ParameterizedType)returnType));
        if (ResultCallAdapterFactory.getRawType((Type)innerType) != Result.class) {
            throw new NotImplementedError("Should not reach here");
        }
        if (!(innerType instanceof ParameterizedType)) {
            throw new IllegalStateException("Response must be parameterized as Result<Foo> or Result<? extends Foo>");
        }
        Type responseType = ResultCallAdapterFactory.getParameterUpperBound((int)0, (ParameterizedType)((ParameterizedType)innerType));
        return new ResultCallAdapter(responseType);
    }

    private static final class ResultCallAdapter<R>
    implements CallAdapter<R, CompletableFuture<Result<R>>> {
        private final Type responseType;

        ResultCallAdapter(Type responseType) {
            this.responseType = responseType;
        }

        public Type responseType() {
            return this.responseType;
        }

        public CompletableFuture<Result<R>> adapt(Call<R> call) {
            CallCancelCompletableFuture future = new CallCancelCompletableFuture(call);
            call.enqueue((Callback)new ResultCallback(future));
            return future;
        }

        private class ResultCallback
        implements Callback<R> {
            private final CompletableFuture<Result<R>> future;

            ResultCallback(CompletableFuture<Result<R>> future) {
                this.future = future;
            }

            public void onResponse(Call<R> call, Response<R> response) {
                this.future.complete(new Result<Object>(response.headers().get("X-Line-Request-Id"), response.headers().get("X-Line-Accepted-Request-Id"), response.body()));
            }

            public void onFailure(Call<R> call, Throwable t) {
                this.future.completeExceptionally(t);
            }
        }
    }

    private static final class CallCancelCompletableFuture<T>
    extends CompletableFuture<T> {
        private final Call<?> call;

        CallCancelCompletableFuture(Call<?> call) {
            this.call = call;
        }

        @Override
        public boolean cancel(boolean mayInterruptIfRunning) {
            if (mayInterruptIfRunning) {
                this.call.cancel();
            }
            return super.cancel(mayInterruptIfRunning);
        }
    }
}

