/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.bot.client.base.exception;

import java.io.IOException;
import java.net.URL;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import okhttp3.Headers;
import okhttp3.Response;

public class AbstractLineClientException
extends IOException {
    private final Response response;

    public AbstractLineClientException(Response response, String message, IOException ioException) {
        super("API returns error: code=" + response.code() + " requestUrl=" + response.request().url() + AbstractLineClientException.headerInfo(response.headers()) + " " + message, ioException);
        this.response = response;
    }

    public AbstractLineClientException(Response response, String message) {
        super("API returns error: code=" + response.code() + " requestUrl=" + response.request().url() + AbstractLineClientException.headerInfo(response.headers()) + " " + message);
        this.response = response;
    }

    public int getCode() {
        return this.response.code();
    }

    public URL getRequestUrl() {
        return this.response.request().url().url();
    }

    public String getRequestId() {
        return this.response.headers().get("x-line-request-id");
    }

    public String getHeader(String name) {
        return this.response.headers().get(name);
    }

    private static String headerInfo(Headers headers) {
        String headerInfo = StreamSupport.stream(headers.spliterator(), false).filter(it -> ((String)it.getFirst()).startsWith("x-line-")).sorted((a, b) -> ((String)a.getFirst()).compareTo((String)b.getSecond())).map(it -> (String)it.getFirst() + "=" + (String)it.getSecond()).collect(Collectors.joining(" "));
        if (headerInfo.isEmpty()) {
            return "";
        }
        return " " + headerInfo;
    }
}

