/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.bot.client.base.http;

import com.linecorp.bot.client.base.http.HttpRequestBody;
import java.net.URL;
import java.util.List;
import java.util.Map;
import okhttp3.Request;
import okhttp3.RequestBody;

public class HttpRequest {
    private final Request request;

    HttpRequest(Request request) {
        this.request = request;
    }

    public Request toOkHttpRequest() {
        return this.request;
    }

    public HttpRequestBuilder newBuilder() {
        return new HttpRequestBuilder(this.request.newBuilder());
    }

    public String method() {
        return this.request.method();
    }

    public URL url() {
        return this.request.url().url();
    }

    public Map<String, List<String>> headers() {
        return this.request.headers().toMultimap();
    }

    public HttpRequestBody body() {
        RequestBody body = this.request.body();
        if (body == null) {
            return null;
        }
        return new HttpRequestBody(body);
    }

    public record HttpRequestBuilder(Request.Builder builder) {
        public HttpRequest build() {
            return new HttpRequest(this.builder.build());
        }

        public HttpRequestBuilder addHeader(String name, String value) {
            this.builder.addHeader(name, value);
            return this;
        }
    }
}

