/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.bot.client.base;

import com.linecorp.bot.client.base.ApiClientBuilder;
import com.linecorp.bot.client.base.ExceptionBuilder;
import com.linecorp.bot.client.base.HeaderInterceptor;
import com.linecorp.bot.client.base.channel.ChannelTokenSupplier;
import com.linecorp.bot.client.base.channel.FixedChannelTokenSupplier;
import java.net.URI;
import java.util.Objects;

public class ApiAuthenticatedClientBuilder<T>
extends ApiClientBuilder<T> {
    private final ChannelTokenSupplier channelTokenSupplier;
    private boolean addAuthenticationHeader = true;

    public ApiAuthenticatedClientBuilder(URI apiEndPoint, Class<T> clientClass, ExceptionBuilder exceptionBuilder, ChannelTokenSupplier channelTokenSupplier) {
        super(apiEndPoint, clientClass, exceptionBuilder);
        this.channelTokenSupplier = channelTokenSupplier;
    }

    public ApiAuthenticatedClientBuilder(URI apiEndPoint, Class<T> clientClass, ExceptionBuilder exceptionBuilder, String channelToken) {
        super(apiEndPoint, clientClass, exceptionBuilder);
        this.channelTokenSupplier = FixedChannelTokenSupplier.of(channelToken);
    }

    public ApiAuthenticatedClientBuilder<T> addAuthenticationHeader(boolean addAuthenticationHeader) {
        this.addAuthenticationHeader = addAuthenticationHeader;
        return this;
    }

    @Override
    public T build() {
        if (this.addAuthenticationHeader) {
            Objects.requireNonNull(this.channelTokenSupplier, "You need to set the channelTokenSupplier for the ApiAuthenticatedClientBuilder before building instance.");
            this.addInterceptor(HeaderInterceptor.forChannelTokenSupplier(this.channelTokenSupplier));
        }
        return super.build();
    }

    @Override
    public String toString() {
        return "ApiAuthenticatedClientBuilder{channelTokenSupplier=" + String.valueOf(this.channelTokenSupplier) + ", addAuthenticationHeader=" + this.addAuthenticationHeader + ", (" + super.toString() + ")}";
    }
}

