/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.bot.client.base;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.linecorp.bot.client.base.BlobContent;
import com.linecorp.bot.client.base.UploadFile;
import java.io.File;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import okhttp3.MediaType;
import okhttp3.RequestBody;
import okhttp3.ResponseBody;
import retrofit2.Converter;
import retrofit2.Retrofit;
import retrofit2.converter.jackson.JacksonConverterFactory;

public class BotAwareJacksonConverter
extends Converter.Factory {
    private final JacksonConverterFactory jacksonConverterFactory;

    private BotAwareJacksonConverter(ObjectMapper mapper) {
        this.jacksonConverterFactory = JacksonConverterFactory.create((ObjectMapper)mapper);
    }

    public static Converter.Factory create(ObjectMapper objectMapper) {
        return new BotAwareJacksonConverter(objectMapper);
    }

    public Converter<ResponseBody, ?> responseBodyConverter(Type type, Annotation[] annotations, Retrofit retrofit) {
        if (type == BlobContent.class) {
            return BlobContent::new;
        }
        return this.jacksonConverterFactory.responseBodyConverter(type, annotations, retrofit);
    }

    public Converter<?, RequestBody> requestBodyConverter(Type type, Annotation[] parameterAnnotations, Annotation[] methodAnnotations, Retrofit retrofit) {
        if (type == UploadFile.class) {
            return this::buildRequestBodyFromUploadFile;
        }
        return this.jacksonConverterFactory.requestBodyConverter(type, parameterAnnotations, methodAnnotations, retrofit);
    }

    private RequestBody buildRequestBodyFromUploadFile(Object o) {
        if (o instanceof UploadFile.StringUploadFile) {
            UploadFile.StringUploadFile uploadFile = (UploadFile.StringUploadFile)o;
            return RequestBody.create((String)uploadFile.src(), (MediaType)MediaType.parse((String)uploadFile.contentType()));
        }
        if (o instanceof UploadFile.FileUploadFile) {
            UploadFile.FileUploadFile uploadFile = (UploadFile.FileUploadFile)o;
            return RequestBody.create((File)uploadFile.src(), (MediaType)MediaType.parse((String)uploadFile.contentType()));
        }
        if (o instanceof UploadFile.ByteArrayUploadFile) {
            UploadFile.ByteArrayUploadFile uploadFile = (UploadFile.ByteArrayUploadFile)o;
            return RequestBody.create((byte[])uploadFile.src(), (MediaType)MediaType.parse((String)uploadFile.contentType()));
        }
        throw new IllegalArgumentException("Unsupported object: " + String.valueOf(o));
    }
}

