/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.bot.client.base;

import com.linecorp.bot.client.base.channel.ChannelTokenSupplier;
import com.linecorp.bot.client.base.http.HttpChain;
import com.linecorp.bot.client.base.http.HttpInterceptor;
import com.linecorp.bot.client.base.http.HttpRequest;
import com.linecorp.bot.client.base.http.HttpResponse;
import java.io.IOException;

public class HeaderInterceptor
implements HttpInterceptor {
    private static final String USER_AGENT = "line-botsdk-java/" + HeaderInterceptor.class.getPackage().getImplementationVersion();
    private final ChannelTokenSupplier channelTokenSupplier;

    private HeaderInterceptor(ChannelTokenSupplier channelTokenSupplier) {
        this.channelTokenSupplier = channelTokenSupplier;
    }

    public static HeaderInterceptor forChannelTokenSupplier(ChannelTokenSupplier channelTokenSupplier) {
        return new HeaderInterceptor(channelTokenSupplier);
    }

    @Override
    public HttpResponse intercept(HttpChain chain) throws IOException {
        String channelToken = (String)this.channelTokenSupplier.get();
        HttpRequest request = chain.request().newBuilder().addHeader("Authorization", "Bearer " + channelToken).addHeader("User-Agent", USER_AGENT).build();
        return chain.proceed(request);
    }
}

