/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.bot.insight.client;

import com.linecorp.bot.client.base.ApiAuthenticatedClientBuilder;
import com.linecorp.bot.client.base.ExceptionBuilder;
import com.linecorp.bot.client.base.Result;
import com.linecorp.bot.client.base.channel.ChannelTokenSupplier;
import com.linecorp.bot.insight.client.InsightExceptionBuilder;
import com.linecorp.bot.insight.model.GetFriendsDemographicsResponse;
import com.linecorp.bot.insight.model.GetMessageEventResponse;
import com.linecorp.bot.insight.model.GetNumberOfFollowersResponse;
import com.linecorp.bot.insight.model.GetNumberOfMessageDeliveriesResponse;
import com.linecorp.bot.insight.model.GetStatisticsPerUnitResponse;
import java.net.URI;
import java.util.concurrent.CompletableFuture;
import retrofit2.http.GET;
import retrofit2.http.Query;

public interface InsightClient {
    @GET(value="/v2/bot/insight/demographic")
    public CompletableFuture<Result<GetFriendsDemographicsResponse>> getFriendsDemographics();

    @GET(value="/v2/bot/insight/message/event")
    public CompletableFuture<Result<GetMessageEventResponse>> getMessageEvent(@Query(value="requestId") String var1);

    @GET(value="/v2/bot/insight/followers")
    public CompletableFuture<Result<GetNumberOfFollowersResponse>> getNumberOfFollowers(@Query(value="date") String var1);

    @GET(value="/v2/bot/insight/message/delivery")
    public CompletableFuture<Result<GetNumberOfMessageDeliveriesResponse>> getNumberOfMessageDeliveries(@Query(value="date") String var1);

    @GET(value="/v2/bot/insight/message/event/aggregation")
    public CompletableFuture<Result<GetStatisticsPerUnitResponse>> getStatisticsPerUnit(@Query(value="customAggregationUnit") String var1, @Query(value="from") String var2, @Query(value="to") String var3);

    public static ApiAuthenticatedClientBuilder<InsightClient> builder(String channelToken) {
        return new ApiAuthenticatedClientBuilder(URI.create("https://api.line.me"), InsightClient.class, (ExceptionBuilder)new InsightExceptionBuilder(), channelToken);
    }

    public static ApiAuthenticatedClientBuilder<InsightClient> builder(ChannelTokenSupplier channelTokenSupplier) {
        return new ApiAuthenticatedClientBuilder(URI.create("https://api.line.me"), InsightClient.class, (ExceptionBuilder)new InsightExceptionBuilder(), channelTokenSupplier);
    }
}

