/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.bot.audience.client;

import com.linecorp.bot.audience.client.ManageAudienceExceptionBuilder;
import com.linecorp.bot.audience.model.AddAudienceToAudienceGroupRequest;
import com.linecorp.bot.audience.model.AudienceGroupCreateRoute;
import com.linecorp.bot.audience.model.AudienceGroupStatus;
import com.linecorp.bot.audience.model.CreateAudienceGroupRequest;
import com.linecorp.bot.audience.model.CreateAudienceGroupResponse;
import com.linecorp.bot.audience.model.CreateClickBasedAudienceGroupRequest;
import com.linecorp.bot.audience.model.CreateClickBasedAudienceGroupResponse;
import com.linecorp.bot.audience.model.CreateImpBasedAudienceGroupRequest;
import com.linecorp.bot.audience.model.CreateImpBasedAudienceGroupResponse;
import com.linecorp.bot.audience.model.GetAudienceDataResponse;
import com.linecorp.bot.audience.model.GetAudienceGroupAuthorityLevelResponse;
import com.linecorp.bot.audience.model.GetAudienceGroupsResponse;
import com.linecorp.bot.audience.model.UpdateAudienceGroupAuthorityLevelRequest;
import com.linecorp.bot.audience.model.UpdateAudienceGroupDescriptionRequest;
import com.linecorp.bot.client.base.ApiAuthenticatedClientBuilder;
import com.linecorp.bot.client.base.ExceptionBuilder;
import com.linecorp.bot.client.base.Result;
import com.linecorp.bot.client.base.channel.ChannelTokenSupplier;
import java.net.URI;
import java.util.concurrent.CompletableFuture;
import retrofit2.http.Body;
import retrofit2.http.DELETE;
import retrofit2.http.GET;
import retrofit2.http.POST;
import retrofit2.http.PUT;
import retrofit2.http.Path;
import retrofit2.http.Query;

public interface ManageAudienceClient {
    @PUT(value="/v2/bot/audienceGroup/{audienceGroupId}/activate")
    public CompletableFuture<Result<Void>> activateAudienceGroup(@Path(value="audienceGroupId") Long var1);

    @PUT(value="/v2/bot/audienceGroup/upload")
    public CompletableFuture<Result<Void>> addAudienceToAudienceGroup(@Body AddAudienceToAudienceGroupRequest var1);

    @POST(value="/v2/bot/audienceGroup/upload")
    public CompletableFuture<Result<CreateAudienceGroupResponse>> createAudienceGroup(@Body CreateAudienceGroupRequest var1);

    @POST(value="/v2/bot/audienceGroup/click")
    public CompletableFuture<Result<CreateClickBasedAudienceGroupResponse>> createClickBasedAudienceGroup(@Body CreateClickBasedAudienceGroupRequest var1);

    @POST(value="/v2/bot/audienceGroup/imp")
    public CompletableFuture<Result<CreateImpBasedAudienceGroupResponse>> createImpBasedAudienceGroup(@Body CreateImpBasedAudienceGroupRequest var1);

    @DELETE(value="/v2/bot/audienceGroup/{audienceGroupId}")
    public CompletableFuture<Result<Void>> deleteAudienceGroup(@Path(value="audienceGroupId") Long var1);

    @GET(value="/v2/bot/audienceGroup/{audienceGroupId}")
    public CompletableFuture<Result<GetAudienceDataResponse>> getAudienceData(@Path(value="audienceGroupId") Long var1);

    @GET(value="/v2/bot/audienceGroup/authorityLevel")
    public CompletableFuture<Result<GetAudienceGroupAuthorityLevelResponse>> getAudienceGroupAuthorityLevel();

    @GET(value="/v2/bot/audienceGroup/list")
    public CompletableFuture<Result<GetAudienceGroupsResponse>> getAudienceGroups(@Query(value="page") Long var1, @Query(value="description") String var2, @Query(value="status") AudienceGroupStatus var3, @Query(value="size") Long var4, @Query(value="includesExternalPublicGroups") Boolean var5, @Query(value="createRoute") AudienceGroupCreateRoute var6);

    @PUT(value="/v2/bot/audienceGroup/authorityLevel")
    public CompletableFuture<Result<Void>> updateAudienceGroupAuthorityLevel(@Body UpdateAudienceGroupAuthorityLevelRequest var1);

    @PUT(value="/v2/bot/audienceGroup/{audienceGroupId}/updateDescription")
    public CompletableFuture<Result<Void>> updateAudienceGroupDescription(@Path(value="audienceGroupId") Long var1, @Body UpdateAudienceGroupDescriptionRequest var2);

    public static ApiAuthenticatedClientBuilder<ManageAudienceClient> builder(String channelToken) {
        return new ApiAuthenticatedClientBuilder(URI.create("https://api.line.me"), ManageAudienceClient.class, (ExceptionBuilder)new ManageAudienceExceptionBuilder(), channelToken);
    }

    public static ApiAuthenticatedClientBuilder<ManageAudienceClient> builder(ChannelTokenSupplier channelTokenSupplier) {
        return new ApiAuthenticatedClientBuilder(URI.create("https://api.line.me"), ManageAudienceClient.class, (ExceptionBuilder)new ManageAudienceExceptionBuilder(), channelTokenSupplier);
    }
}

