/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.bot.messaging.client;

import com.linecorp.bot.client.base.ApiAuthenticatedClientBuilder;
import com.linecorp.bot.client.base.BlobContent;
import com.linecorp.bot.client.base.ExceptionBuilder;
import com.linecorp.bot.client.base.Result;
import com.linecorp.bot.client.base.UploadFile;
import com.linecorp.bot.client.base.channel.ChannelTokenSupplier;
import com.linecorp.bot.messaging.client.MessagingApiExceptionBuilder;
import com.linecorp.bot.messaging.model.GetMessageContentTranscodingResponse;
import java.net.URI;
import java.util.concurrent.CompletableFuture;
import retrofit2.http.Body;
import retrofit2.http.GET;
import retrofit2.http.POST;
import retrofit2.http.Path;
import retrofit2.http.Streaming;

public interface MessagingApiBlobClient {
    @Streaming
    @GET(value="/v2/bot/message/{messageId}/content")
    public CompletableFuture<Result<BlobContent>> getMessageContent(@Path(value="messageId") String var1);

    @Streaming
    @GET(value="/v2/bot/message/{messageId}/content/preview")
    public CompletableFuture<Result<BlobContent>> getMessageContentPreview(@Path(value="messageId") String var1);

    @GET(value="/v2/bot/message/{messageId}/content/transcoding")
    public CompletableFuture<Result<GetMessageContentTranscodingResponse>> getMessageContentTranscodingByMessageId(@Path(value="messageId") String var1);

    @Streaming
    @GET(value="/v2/bot/richmenu/{richMenuId}/content")
    public CompletableFuture<Result<BlobContent>> getRichMenuImage(@Path(value="richMenuId") String var1);

    @POST(value="/v2/bot/richmenu/{richMenuId}/content")
    public CompletableFuture<Result<Void>> setRichMenuImage(@Path(value="richMenuId") String var1, @Body UploadFile var2);

    public static ApiAuthenticatedClientBuilder<MessagingApiBlobClient> builder(String channelToken) {
        return new ApiAuthenticatedClientBuilder(URI.create("https://api-data.line.me"), MessagingApiBlobClient.class, (ExceptionBuilder)new MessagingApiExceptionBuilder(), channelToken);
    }

    public static ApiAuthenticatedClientBuilder<MessagingApiBlobClient> builder(ChannelTokenSupplier channelTokenSupplier) {
        return new ApiAuthenticatedClientBuilder(URI.create("https://api-data.line.me"), MessagingApiBlobClient.class, (ExceptionBuilder)new MessagingApiExceptionBuilder(), channelTokenSupplier);
    }
}

