/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.bot.messaging.client;

import com.linecorp.bot.client.base.ApiAuthenticatedClientBuilder;
import com.linecorp.bot.client.base.ExceptionBuilder;
import com.linecorp.bot.client.base.Result;
import com.linecorp.bot.client.base.channel.ChannelTokenSupplier;
import com.linecorp.bot.messaging.client.MessagingApiExceptionBuilder;
import com.linecorp.bot.messaging.model.BotInfoResponse;
import com.linecorp.bot.messaging.model.BroadcastRequest;
import com.linecorp.bot.messaging.model.CreateRichMenuAliasRequest;
import com.linecorp.bot.messaging.model.GetAggregationUnitNameListResponse;
import com.linecorp.bot.messaging.model.GetAggregationUnitUsageResponse;
import com.linecorp.bot.messaging.model.GetFollowersResponse;
import com.linecorp.bot.messaging.model.GetJoinedMembershipUsersResponse;
import com.linecorp.bot.messaging.model.GetMembershipSubscriptionResponse;
import com.linecorp.bot.messaging.model.GetWebhookEndpointResponse;
import com.linecorp.bot.messaging.model.GroupMemberCountResponse;
import com.linecorp.bot.messaging.model.GroupSummaryResponse;
import com.linecorp.bot.messaging.model.GroupUserProfileResponse;
import com.linecorp.bot.messaging.model.IssueLinkTokenResponse;
import com.linecorp.bot.messaging.model.MarkMessagesAsReadRequest;
import com.linecorp.bot.messaging.model.MembersIdsResponse;
import com.linecorp.bot.messaging.model.MembershipListResponse;
import com.linecorp.bot.messaging.model.MessageQuotaResponse;
import com.linecorp.bot.messaging.model.MulticastRequest;
import com.linecorp.bot.messaging.model.NarrowcastProgressResponse;
import com.linecorp.bot.messaging.model.NarrowcastRequest;
import com.linecorp.bot.messaging.model.NumberOfMessagesResponse;
import com.linecorp.bot.messaging.model.PnpMessagesRequest;
import com.linecorp.bot.messaging.model.PushMessageRequest;
import com.linecorp.bot.messaging.model.PushMessageResponse;
import com.linecorp.bot.messaging.model.QuotaConsumptionResponse;
import com.linecorp.bot.messaging.model.ReplyMessageRequest;
import com.linecorp.bot.messaging.model.ReplyMessageResponse;
import com.linecorp.bot.messaging.model.RichMenuAliasListResponse;
import com.linecorp.bot.messaging.model.RichMenuAliasResponse;
import com.linecorp.bot.messaging.model.RichMenuBatchProgressResponse;
import com.linecorp.bot.messaging.model.RichMenuBatchRequest;
import com.linecorp.bot.messaging.model.RichMenuBulkLinkRequest;
import com.linecorp.bot.messaging.model.RichMenuBulkUnlinkRequest;
import com.linecorp.bot.messaging.model.RichMenuIdResponse;
import com.linecorp.bot.messaging.model.RichMenuListResponse;
import com.linecorp.bot.messaging.model.RichMenuRequest;
import com.linecorp.bot.messaging.model.RichMenuResponse;
import com.linecorp.bot.messaging.model.RoomMemberCountResponse;
import com.linecorp.bot.messaging.model.RoomUserProfileResponse;
import com.linecorp.bot.messaging.model.SetWebhookEndpointRequest;
import com.linecorp.bot.messaging.model.ShowLoadingAnimationRequest;
import com.linecorp.bot.messaging.model.TestWebhookEndpointRequest;
import com.linecorp.bot.messaging.model.TestWebhookEndpointResponse;
import com.linecorp.bot.messaging.model.UpdateRichMenuAliasRequest;
import com.linecorp.bot.messaging.model.UserProfileResponse;
import com.linecorp.bot.messaging.model.ValidateMessageRequest;
import java.net.URI;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import retrofit2.http.Body;
import retrofit2.http.DELETE;
import retrofit2.http.GET;
import retrofit2.http.Header;
import retrofit2.http.POST;
import retrofit2.http.PUT;
import retrofit2.http.Path;
import retrofit2.http.Query;

public interface MessagingApiClient {
    @POST(value="/v2/bot/message/broadcast")
    public CompletableFuture<Result<Object>> broadcast(@Header(value="X-Line-Retry-Key") UUID var1, @Body BroadcastRequest var2);

    @DELETE(value="/v2/bot/user/all/richmenu")
    public CompletableFuture<Result<Void>> cancelDefaultRichMenu();

    @POST(value="/v2/bot/richmenu")
    public CompletableFuture<Result<RichMenuIdResponse>> createRichMenu(@Body RichMenuRequest var1);

    @POST(value="/v2/bot/richmenu/alias")
    public CompletableFuture<Result<Void>> createRichMenuAlias(@Body CreateRichMenuAliasRequest var1);

    @DELETE(value="/v2/bot/richmenu/{richMenuId}")
    public CompletableFuture<Result<Void>> deleteRichMenu(@Path(value="richMenuId") String var1);

    @DELETE(value="/v2/bot/richmenu/alias/{richMenuAliasId}")
    public CompletableFuture<Result<Void>> deleteRichMenuAlias(@Path(value="richMenuAliasId") String var1);

    @GET(value="/v2/bot/message/aggregation/list")
    public CompletableFuture<Result<GetAggregationUnitNameListResponse>> getAggregationUnitNameList(@Query(value="limit") String var1, @Query(value="start") String var2);

    @GET(value="/v2/bot/message/aggregation/info")
    public CompletableFuture<Result<GetAggregationUnitUsageResponse>> getAggregationUnitUsage();

    @GET(value="/v2/bot/info")
    public CompletableFuture<Result<BotInfoResponse>> getBotInfo();

    @GET(value="/v2/bot/user/all/richmenu")
    public CompletableFuture<Result<RichMenuIdResponse>> getDefaultRichMenuId();

    @GET(value="/v2/bot/followers/ids")
    public CompletableFuture<Result<GetFollowersResponse>> getFollowers(@Query(value="start") String var1, @Query(value="limit") Integer var2);

    @GET(value="/v2/bot/group/{groupId}/members/count")
    public CompletableFuture<Result<GroupMemberCountResponse>> getGroupMemberCount(@Path(value="groupId") String var1);

    @GET(value="/v2/bot/group/{groupId}/member/{userId}")
    public CompletableFuture<Result<GroupUserProfileResponse>> getGroupMemberProfile(@Path(value="groupId") String var1, @Path(value="userId") String var2);

    @GET(value="/v2/bot/group/{groupId}/members/ids")
    public CompletableFuture<Result<MembersIdsResponse>> getGroupMembersIds(@Path(value="groupId") String var1, @Query(value="start") String var2);

    @GET(value="/v2/bot/group/{groupId}/summary")
    public CompletableFuture<Result<GroupSummaryResponse>> getGroupSummary(@Path(value="groupId") String var1);

    @GET(value="/v2/bot/membership/{membershipId}/users/ids")
    public CompletableFuture<Result<GetJoinedMembershipUsersResponse>> getJoinedMembershipUsers(@Path(value="membershipId") Integer var1, @Query(value="start") String var2, @Query(value="limit") Integer var3);

    @GET(value="/v2/bot/membership/list")
    public CompletableFuture<Result<MembershipListResponse>> getMembershipList();

    @GET(value="/v2/bot/membership/subscription/{userId}")
    public CompletableFuture<Result<GetMembershipSubscriptionResponse>> getMembershipSubscription(@Path(value="userId") String var1);

    @GET(value="/v2/bot/message/quota")
    public CompletableFuture<Result<MessageQuotaResponse>> getMessageQuota();

    @GET(value="/v2/bot/message/quota/consumption")
    public CompletableFuture<Result<QuotaConsumptionResponse>> getMessageQuotaConsumption();

    @GET(value="/v2/bot/message/progress/narrowcast")
    public CompletableFuture<Result<NarrowcastProgressResponse>> getNarrowcastProgress(@Query(value="requestId") String var1);

    @GET(value="/v2/bot/message/delivery/broadcast")
    public CompletableFuture<Result<NumberOfMessagesResponse>> getNumberOfSentBroadcastMessages(@Query(value="date") String var1);

    @GET(value="/v2/bot/message/delivery/multicast")
    public CompletableFuture<Result<NumberOfMessagesResponse>> getNumberOfSentMulticastMessages(@Query(value="date") String var1);

    @GET(value="/v2/bot/message/delivery/push")
    public CompletableFuture<Result<NumberOfMessagesResponse>> getNumberOfSentPushMessages(@Query(value="date") String var1);

    @GET(value="/v2/bot/message/delivery/reply")
    public CompletableFuture<Result<NumberOfMessagesResponse>> getNumberOfSentReplyMessages(@Query(value="date") String var1);

    @GET(value="/v2/bot/message/delivery/pnp")
    public CompletableFuture<Result<NumberOfMessagesResponse>> getPNPMessageStatistics(@Query(value="date") String var1);

    @GET(value="/v2/bot/profile/{userId}")
    public CompletableFuture<Result<UserProfileResponse>> getProfile(@Path(value="userId") String var1);

    @GET(value="/v2/bot/richmenu/{richMenuId}")
    public CompletableFuture<Result<RichMenuResponse>> getRichMenu(@Path(value="richMenuId") String var1);

    @GET(value="/v2/bot/richmenu/alias/{richMenuAliasId}")
    public CompletableFuture<Result<RichMenuAliasResponse>> getRichMenuAlias(@Path(value="richMenuAliasId") String var1);

    @GET(value="/v2/bot/richmenu/alias/list")
    public CompletableFuture<Result<RichMenuAliasListResponse>> getRichMenuAliasList();

    @GET(value="/v2/bot/richmenu/progress/batch")
    public CompletableFuture<Result<RichMenuBatchProgressResponse>> getRichMenuBatchProgress(@Query(value="requestId") String var1);

    @GET(value="/v2/bot/user/{userId}/richmenu")
    public CompletableFuture<Result<RichMenuIdResponse>> getRichMenuIdOfUser(@Path(value="userId") String var1);

    @GET(value="/v2/bot/richmenu/list")
    public CompletableFuture<Result<RichMenuListResponse>> getRichMenuList();

    @GET(value="/v2/bot/room/{roomId}/members/count")
    public CompletableFuture<Result<RoomMemberCountResponse>> getRoomMemberCount(@Path(value="roomId") String var1);

    @GET(value="/v2/bot/room/{roomId}/member/{userId}")
    public CompletableFuture<Result<RoomUserProfileResponse>> getRoomMemberProfile(@Path(value="roomId") String var1, @Path(value="userId") String var2);

    @GET(value="/v2/bot/room/{roomId}/members/ids")
    public CompletableFuture<Result<MembersIdsResponse>> getRoomMembersIds(@Path(value="roomId") String var1, @Query(value="start") String var2);

    @GET(value="/v2/bot/channel/webhook/endpoint")
    public CompletableFuture<Result<GetWebhookEndpointResponse>> getWebhookEndpoint();

    @POST(value="/v2/bot/user/{userId}/linkToken")
    public CompletableFuture<Result<IssueLinkTokenResponse>> issueLinkToken(@Path(value="userId") String var1);

    @POST(value="/v2/bot/group/{groupId}/leave")
    public CompletableFuture<Result<Void>> leaveGroup(@Path(value="groupId") String var1);

    @POST(value="/v2/bot/room/{roomId}/leave")
    public CompletableFuture<Result<Void>> leaveRoom(@Path(value="roomId") String var1);

    @POST(value="/v2/bot/user/{userId}/richmenu/{richMenuId}")
    public CompletableFuture<Result<Void>> linkRichMenuIdToUser(@Path(value="userId") String var1, @Path(value="richMenuId") String var2);

    @POST(value="/v2/bot/richmenu/bulk/link")
    public CompletableFuture<Result<Void>> linkRichMenuIdToUsers(@Body RichMenuBulkLinkRequest var1);

    @POST(value="/v2/bot/message/markAsRead")
    public CompletableFuture<Result<Void>> markMessagesAsRead(@Body MarkMessagesAsReadRequest var1);

    @POST(value="/v2/bot/message/multicast")
    public CompletableFuture<Result<Object>> multicast(@Header(value="X-Line-Retry-Key") UUID var1, @Body MulticastRequest var2);

    @POST(value="/v2/bot/message/narrowcast")
    public CompletableFuture<Result<Object>> narrowcast(@Header(value="X-Line-Retry-Key") UUID var1, @Body NarrowcastRequest var2);

    @POST(value="/v2/bot/message/push")
    public CompletableFuture<Result<PushMessageResponse>> pushMessage(@Header(value="X-Line-Retry-Key") UUID var1, @Body PushMessageRequest var2);

    @POST(value="/bot/pnp/push")
    public CompletableFuture<Result<Void>> pushMessagesByPhone(@Header(value="X-Line-Delivery-Tag") String var1, @Body PnpMessagesRequest var2);

    @POST(value="/v2/bot/message/reply")
    public CompletableFuture<Result<ReplyMessageResponse>> replyMessage(@Body ReplyMessageRequest var1);

    @POST(value="/v2/bot/richmenu/batch")
    public CompletableFuture<Result<Void>> richMenuBatch(@Body RichMenuBatchRequest var1);

    @POST(value="/v2/bot/user/all/richmenu/{richMenuId}")
    public CompletableFuture<Result<Void>> setDefaultRichMenu(@Path(value="richMenuId") String var1);

    @PUT(value="/v2/bot/channel/webhook/endpoint")
    public CompletableFuture<Result<Void>> setWebhookEndpoint(@Body SetWebhookEndpointRequest var1);

    @POST(value="/v2/bot/chat/loading/start")
    public CompletableFuture<Result<Object>> showLoadingAnimation(@Body ShowLoadingAnimationRequest var1);

    @POST(value="/v2/bot/channel/webhook/test")
    public CompletableFuture<Result<TestWebhookEndpointResponse>> testWebhookEndpoint(@Body TestWebhookEndpointRequest var1);

    @DELETE(value="/v2/bot/user/{userId}/richmenu")
    public CompletableFuture<Result<Void>> unlinkRichMenuIdFromUser(@Path(value="userId") String var1);

    @POST(value="/v2/bot/richmenu/bulk/unlink")
    public CompletableFuture<Result<Void>> unlinkRichMenuIdFromUsers(@Body RichMenuBulkUnlinkRequest var1);

    @POST(value="/v2/bot/richmenu/alias/{richMenuAliasId}")
    public CompletableFuture<Result<Void>> updateRichMenuAlias(@Path(value="richMenuAliasId") String var1, @Body UpdateRichMenuAliasRequest var2);

    @POST(value="/v2/bot/message/validate/broadcast")
    public CompletableFuture<Result<Void>> validateBroadcast(@Body ValidateMessageRequest var1);

    @POST(value="/v2/bot/message/validate/multicast")
    public CompletableFuture<Result<Void>> validateMulticast(@Body ValidateMessageRequest var1);

    @POST(value="/v2/bot/message/validate/narrowcast")
    public CompletableFuture<Result<Void>> validateNarrowcast(@Body ValidateMessageRequest var1);

    @POST(value="/v2/bot/message/validate/push")
    public CompletableFuture<Result<Void>> validatePush(@Body ValidateMessageRequest var1);

    @POST(value="/v2/bot/message/validate/reply")
    public CompletableFuture<Result<Void>> validateReply(@Body ValidateMessageRequest var1);

    @POST(value="/v2/bot/richmenu/validate/batch")
    public CompletableFuture<Result<Void>> validateRichMenuBatchRequest(@Body RichMenuBatchRequest var1);

    @POST(value="/v2/bot/richmenu/validate")
    public CompletableFuture<Result<Void>> validateRichMenuObject(@Body RichMenuRequest var1);

    public static ApiAuthenticatedClientBuilder<MessagingApiClient> builder(String channelToken) {
        return new ApiAuthenticatedClientBuilder(URI.create("https://api.line.me"), MessagingApiClient.class, (ExceptionBuilder)new MessagingApiExceptionBuilder(), channelToken);
    }

    public static ApiAuthenticatedClientBuilder<MessagingApiClient> builder(ChannelTokenSupplier channelTokenSupplier) {
        return new ApiAuthenticatedClientBuilder(URI.create("https://api.line.me"), MessagingApiClient.class, (ExceptionBuilder)new MessagingApiExceptionBuilder(), channelTokenSupplier);
    }
}

