/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.bot.messaging.client;

import com.linecorp.bot.client.base.exception.AbstractLineClientException;
import com.linecorp.bot.messaging.model.ErrorDetail;
import com.linecorp.bot.messaging.model.SentMessage;
import java.util.Collections;
import java.util.List;
import okhttp3.Response;

public class MessagingApiClientException
extends AbstractLineClientException {
    private final String error;
    private final List<ErrorDetail> details;
    private final List<SentMessage> sentMessages;

    public MessagingApiClientException(Response response, String error, List<ErrorDetail> details, List<SentMessage> sentMessages) {
        super(response, "error='" + error + "' details='" + String.valueOf(details) + "' sentMessages='" + String.valueOf(sentMessages) + "'");
        this.error = error;
        this.details = details;
        this.sentMessages = sentMessages;
    }

    public String getError() {
        return this.error;
    }

    public List<ErrorDetail> getDetails() {
        if (this.details == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(this.details);
    }

    public List<SentMessage> getSentMessages() {
        if (this.sentMessages == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(this.sentMessages);
    }
}

