/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.bot.messaging.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.linecorp.bot.messaging.model.Message;
import com.linecorp.bot.messaging.model.QuickReply;
import com.linecorp.bot.messaging.model.Sender;
import java.net.URI;

@JsonTypeName(value="audio")
@JsonInclude(value=JsonInclude.Include.NON_NULL)
public record AudioMessage(@JsonProperty(value="quickReply") QuickReply quickReply, @JsonProperty(value="sender") Sender sender, @JsonProperty(value="originalContentUrl") URI originalContentUrl, @JsonProperty(value="duration") Long duration) implements Message
{
    public AudioMessage(URI originalContentUrl, Long duration) {
        this(null, null, originalContentUrl, duration);
    }

    public static class Builder {
        private QuickReply quickReply;
        private Sender sender;
        private URI originalContentUrl;
        private Long duration;

        public Builder(URI originalContentUrl, Long duration) {
            this.originalContentUrl = originalContentUrl;
            this.duration = duration;
        }

        public Builder quickReply(QuickReply quickReply) {
            this.quickReply = quickReply;
            return this;
        }

        public Builder sender(Sender sender) {
            this.sender = sender;
            return this;
        }

        public AudioMessage build() {
            return new AudioMessage(this.quickReply, this.sender, this.originalContentUrl, this.duration);
        }
    }
}

