/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.bot.messaging.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.linecorp.bot.messaging.model.Action;
import com.linecorp.bot.messaging.model.FlexBoxBackground;
import com.linecorp.bot.messaging.model.FlexComponent;
import java.util.List;

@JsonTypeName(value="box")
@JsonInclude(value=JsonInclude.Include.NON_NULL)
public record FlexBox(@JsonProperty(value="layout") Layout layout, @JsonProperty(value="flex") Integer flex, @JsonProperty(value="contents") List<FlexComponent> contents, @JsonProperty(value="spacing") String spacing, @JsonProperty(value="margin") String margin, @JsonProperty(value="position") Position position, @JsonProperty(value="offsetTop") String offsetTop, @JsonProperty(value="offsetBottom") String offsetBottom, @JsonProperty(value="offsetStart") String offsetStart, @JsonProperty(value="offsetEnd") String offsetEnd, @JsonProperty(value="backgroundColor") String backgroundColor, @JsonProperty(value="borderColor") String borderColor, @JsonProperty(value="borderWidth") String borderWidth, @JsonProperty(value="cornerRadius") String cornerRadius, @JsonProperty(value="width") String width, @JsonProperty(value="maxWidth") String maxWidth, @JsonProperty(value="height") String height, @JsonProperty(value="maxHeight") String maxHeight, @JsonProperty(value="paddingAll") String paddingAll, @JsonProperty(value="paddingTop") String paddingTop, @JsonProperty(value="paddingBottom") String paddingBottom, @JsonProperty(value="paddingStart") String paddingStart, @JsonProperty(value="paddingEnd") String paddingEnd, @JsonProperty(value="action") Action action, @JsonProperty(value="justifyContent") JustifyContent justifyContent, @JsonProperty(value="alignItems") AlignItems alignItems, @JsonProperty(value="background") FlexBoxBackground background) implements FlexComponent
{

    public static enum Layout {
        HORIZONTAL,
        VERTICAL,
        BASELINE,
        UNDEFINED;

    }

    public static enum Position {
        RELATIVE,
        ABSOLUTE,
        UNDEFINED;

    }

    public static enum JustifyContent {
        CENTER,
        FLEX_START,
        FLEX_END,
        SPACE_BETWEEN,
        SPACE_AROUND,
        SPACE_EVENLY,
        UNDEFINED;

    }

    public static enum AlignItems {
        CENTER,
        FLEX_START,
        FLEX_END,
        UNDEFINED;

    }

    public static class Builder {
        private Layout layout;
        private Integer flex;
        private List<FlexComponent> contents;
        private String spacing;
        private String margin;
        private Position position;
        private String offsetTop;
        private String offsetBottom;
        private String offsetStart;
        private String offsetEnd;
        private String backgroundColor;
        private String borderColor;
        private String borderWidth;
        private String cornerRadius;
        private String width;
        private String maxWidth;
        private String height;
        private String maxHeight;
        private String paddingAll;
        private String paddingTop;
        private String paddingBottom;
        private String paddingStart;
        private String paddingEnd;
        private Action action;
        private JustifyContent justifyContent;
        private AlignItems alignItems;
        private FlexBoxBackground background;

        public Builder(Layout layout, List<FlexComponent> contents) {
            this.layout = layout;
            this.contents = contents;
        }

        public Builder flex(Integer flex) {
            this.flex = flex;
            return this;
        }

        public Builder spacing(String spacing) {
            this.spacing = spacing;
            return this;
        }

        public Builder margin(String margin) {
            this.margin = margin;
            return this;
        }

        public Builder position(Position position) {
            this.position = position;
            return this;
        }

        public Builder offsetTop(String offsetTop) {
            this.offsetTop = offsetTop;
            return this;
        }

        public Builder offsetBottom(String offsetBottom) {
            this.offsetBottom = offsetBottom;
            return this;
        }

        public Builder offsetStart(String offsetStart) {
            this.offsetStart = offsetStart;
            return this;
        }

        public Builder offsetEnd(String offsetEnd) {
            this.offsetEnd = offsetEnd;
            return this;
        }

        public Builder backgroundColor(String backgroundColor) {
            this.backgroundColor = backgroundColor;
            return this;
        }

        public Builder borderColor(String borderColor) {
            this.borderColor = borderColor;
            return this;
        }

        public Builder borderWidth(String borderWidth) {
            this.borderWidth = borderWidth;
            return this;
        }

        public Builder cornerRadius(String cornerRadius) {
            this.cornerRadius = cornerRadius;
            return this;
        }

        public Builder width(String width) {
            this.width = width;
            return this;
        }

        public Builder maxWidth(String maxWidth) {
            this.maxWidth = maxWidth;
            return this;
        }

        public Builder height(String height) {
            this.height = height;
            return this;
        }

        public Builder maxHeight(String maxHeight) {
            this.maxHeight = maxHeight;
            return this;
        }

        public Builder paddingAll(String paddingAll) {
            this.paddingAll = paddingAll;
            return this;
        }

        public Builder paddingTop(String paddingTop) {
            this.paddingTop = paddingTop;
            return this;
        }

        public Builder paddingBottom(String paddingBottom) {
            this.paddingBottom = paddingBottom;
            return this;
        }

        public Builder paddingStart(String paddingStart) {
            this.paddingStart = paddingStart;
            return this;
        }

        public Builder paddingEnd(String paddingEnd) {
            this.paddingEnd = paddingEnd;
            return this;
        }

        public Builder action(Action action) {
            this.action = action;
            return this;
        }

        public Builder justifyContent(JustifyContent justifyContent) {
            this.justifyContent = justifyContent;
            return this;
        }

        public Builder alignItems(AlignItems alignItems) {
            this.alignItems = alignItems;
            return this;
        }

        public Builder background(FlexBoxBackground background) {
            this.background = background;
            return this;
        }

        public FlexBox build() {
            return new FlexBox(this.layout, this.flex, this.contents, this.spacing, this.margin, this.position, this.offsetTop, this.offsetBottom, this.offsetStart, this.offsetEnd, this.backgroundColor, this.borderColor, this.borderWidth, this.cornerRadius, this.width, this.maxWidth, this.height, this.maxHeight, this.paddingAll, this.paddingTop, this.paddingBottom, this.paddingStart, this.paddingEnd, this.action, this.justifyContent, this.alignItems, this.background);
        }
    }
}

